<?php
/*
Chatstack - https://www.chatstack.com
Copyright - All Rights Reserved - Stardevelop Pty Ltd

You may not distribute this program in any manner,
modified or otherwise, without the express, written
consent from Stardevelop Pty Ltd (https://www.chatstack.com)

You may make modifications, but only for your own
use and within the confines of the License Agreement.
All rights reserved.

Selling the code for this program without prior
written consent is expressly forbidden. Obtain
permission before redistributing this program over
the Internet or in any other medium.  In all cases
copyright and header must remain intact.
*/
namespace stardevelop\chatstack;

use Illuminate\Database\Eloquent\Model as Eloquent;


class Activity extends Eloquent {
	protected $table = TABLEPREFIX . 'activity';
	protected $connection = 'default';

	public $timestamps = false;
}


class OperatorMessage extends Eloquent {
	protected $table = TABLEPREFIX . 'operatormessages';
	protected $connection = 'default';

	public $timestamps = false;
}


class Callback extends Eloquent {
	protected $table = TABLEPREFIX . 'callback';
	protected $connection = 'default';

	public $timestamps = false;
}


class Country extends Eloquent {
	protected $table = TABLEPREFIX . 'countries';
	protected $connection = 'default';
	protected $primaryKey = 'code';

	public $timestamps = false;
}


class Department extends Eloquent {
	protected $table = TABLEPREFIX . 'departments';
	protected $connection = 'default';

	public $timestamps = false;
}


class Device extends Eloquent {
	protected $table = TABLEPREFIX . 'devices';
	protected $connection = 'default';

	public $timestamps = false;
}


class Message extends Eloquent {
	protected $table = TABLEPREFIX . 'messages';
	protected $connection = 'default';

	public $timestamps = false;

	public function operator() {
		return $this->hasOne(__namespace__ . '\Operator', 'username', 'username');
	}
}


class Response extends Eloquent {
	protected $table = TABLEPREFIX . 'responses';
	protected $connection = 'default';

	public $timestamps = false;
}


class Chat extends Eloquent {
	protected $table = TABLEPREFIX . 'chats';
	protected $connection = 'default';

	public $timestamps = false;
	public $channel = false;

	public function messages() {
		return $this->hasMany(__namespace__ . '\Message', 'chat');
	}

	public function custom() {
		return $this->hasOne(__namespace__ . '\Custom', 'request', 'request');
	}

	public function rating() {
		return $this->hasMany(__namespace__ . '\Rating', 'chat');
	}

	public function session() {
		return $this->hasMany(__namespace__ . '\ChatSession', 'chat');
	}

	public function typing() {
		return $this->hasOne(__namespace__ . '\Typing', 'chat');
	}

	public function visitor() {
		return $this->hasOne(__namespace__ . '\ChatVisitor', 'chat');
	}

	public static function has_department($chat, $department) {
		$result = false;
		$departments = explode(';', $department);
		if (!empty($chat->department)) {
			if (is_array($departments)) {
				foreach ($departments as $key => $value) {
					if ($chat->department == trim($value)) {
						$result = true;
					}
				}
			}
		} else {
			$result = true;
		}
		return $result;
	}

	public static function has_visitor($chat) {
		global $_SETTINGS;
		global $hooks;

		$visitor = false;
		if (!empty($chat)) {
			if ($_SETTINGS['DATABASEVERSION'] > 10) {
				if (!empty($chat->id) && (int)$chat->id > 0) {
					$chatvisitor = ChatVisitor::where('chat', $chat->id)->first();
					if (!empty($chatvisitor)) {
						if (is_numeric($chatvisitor->visitor) && (int)$chatvisitor->visitor > 0) {
							$visitor = Visitor::find($chatvisitor->visitor);
						} else {
							$hash = false;
							$id = $chat->id;
							$prefix = 'visitor:' . ACCOUNT . ':';
							if (strpos($chatvisitor->visitor, $prefix) > -1) {
								$hash = str_replace($prefix, '', $chatvisitor->visitor);
								$result = $hooks->run('VisitorLoaded', array('id' => $hash, 'visitor' => $visitor));
								if (is_array($result) && isset($result['visitor'])) {
									$visitor = $result['visitor'];
								}
							}
						}
					}
				}
			} else {
				if (!empty($chat->request) && (int)$chat->request > 0) {
					$visitor = Visitor::find($chat->request);
				}
			}
		}
		return $visitor;
	}

}


class Geolocation extends Eloquent {
	protected $table = TABLEPREFIX . 'geolocation';
	protected $connection = 'default';

	public $timestamps = false;
}


class Custom extends Eloquent {
	protected $table = TABLEPREFIX . 'custom';
	protected $connection = 'default';

	public $timestamps = false;
}


class Visitor extends Eloquent {
	protected $table = TABLEPREFIX . 'requests';
	protected $connection = 'default';

	public $timestamps = false;

	public $company = false;
	public $address = false;
	public $telephone = false;
	public $groups = array();
	public $socket = false;
	public $custom = false;
	public $chats = array();

	public function geolocation() {
		return $this->hasOne(__namespace__ . '\Geolocation', 'request');
	}

	public function custom() {
		return $this->hasMany(__namespace__ . '\Custom', 'request', 'request');
	}
}


class Operator extends Eloquent {
	protected $table = TABLEPREFIX . 'users';
	protected $connection = 'default';

	public $timestamps = false;

	public function devices() {
		return $this->hasMany(__namespace__ . '\Device', 'user');
	}

	public function status() {
		global $_SETTINGS;

		$status = 0;
		
		$active = false;
		if (!empty($this->refresh)) {
			$active = time() - strtotime($this->refresh) < $_SETTINGS['CONNECTIONTIMEOUT'];
		}

		if ((int)$_SETTINGS['DATABASEVERSION'] >= 10) {
			if ($active || $this->devices->count() > 0 || (defined('WEBSOCKETS') && $this->websocket->where('active', '>', 0)->count() > 0)) {
				$status = (int)$this->status;
			}
		} elseif ((float)$_SETTINGS['SERVERVERSION'] >= 4.1) {
			if ($active || $this->devices->count() > 0) {
				$status = (int)$this->status;
			}
		} elseif ((float)$_SETTINGS['SERVERVERSION'] >= 3.80) {
			if ($active || !empty($this->device->count())) {
				$status = (int)$this->status;
			}
		} else {
			if ($active) {
				$status = (int)$this->status;
			}
		}
		return $status;
	}

	public function websocket() {
		return $this->hasOne(__namespace__ . '\Websocket', 'id');
	}

	public static function has_department($user, $department) {
		$result = false;
		$departments = explode(';', $user->department);
		if (is_array($departments)) {
			foreach ($departments as $key => $value) {
				if ($department == trim($value)) {
					$result = true;
				}
			}
		}
		return $result;
	}

}


class Operators {
	public static $online = array();
	public static $hidden = array();
	public static $away = array();
	public static $brb = array();
	public static $unavailable = array();
}


class Rating extends Eloquent {
	protected $table = TABLEPREFIX . 'ratings';
	protected $connection = 'default';

	public $timestamps = false;
}


class ChatSession extends Eloquent {
	protected $table = TABLEPREFIX . 'sessions';
	protected $connection = 'default';

	public $timestamps = false;

	public function operator() {
		return $this->hasOne(__namespace__ . '\Operator', 'id', 'user');
	}
}


class Typing extends Eloquent {
	protected $table = TABLEPREFIX . 'typing';
	protected $connection = 'default';

	public $timestamps = false;
}


class ChatVisitor extends Eloquent {
	protected $table = TABLEPREFIX . 'chatvisitors';
	protected $connection = 'default';

	public $timestamps = false;

	public function visitor() {
		return $this->hasOne(__namespace__ . '\Visitor', 'id', 'visitor');
	}

	public function chat() {
		return $this->hasOne(__namespace__ . '\Chat', 'id', 'chat');
	}

	public function custom() {
		return $this->hasOne(__namespace__ . '\Custom', 'request', 'visitor');
	}
}


class InitiateChat extends Eloquent {
	protected $table = TABLEPREFIX . 'initiatechat';
	protected $connection = 'default';

	public $timestamps = false;
}


class Address {
	public $address1;
	public $address2;
	public $city;
	public $state;
	public $postcode;
	public $country;
}


class VisitorGroup {
	public $id = false;
	public $name = false;
	public $sections = array();
	public $position = false;
}


class VisitorSection {
	public $id = false;
	public $name = false;
	public $items = array();
	public $position = false;
}


class VisitorItem {
	public $label = false;
	public $value = false;
}

?>
