<?php
/*
Chatstack - https://www.chatstack.com
Copyright - All Rights Reserved - Stardevelop Pty Ltd

You may not distribute this program in any manner,
modified or otherwise, without the express, written
consent from Stardevelop Pty Ltd (https://www.chatstack.com)

You may make modifications, but only for your own
use and within the confines of the License Agreement.
All rights reserved.

Selling the code for this program without prior
written consent is expressly forbidden. Obtain
permission before redistributing this program over
the Internet or in any other medium.  In all cases
copyright and header must remain intact.
*/
namespace stardevelop\chatstack;

//use Whoops\Handler\PrettyPageHandler;

use Illuminate\Events\Dispatcher;
use Illuminate\Container\Container;
use Illuminate\Database\Capsule\Manager as Capsule;


if (!isset($_PLUGINS)) { $_PLUGINS = array(); }
if ((isset($_PLUGINS['WHMCS']) || defined('WHMCS')) && !defined('CHATSTACK')) {
	return;
}

// Error Reporting
$errortypes = E_ALL & ~E_NOTICE;
error_reporting($errortypes);
if (getenv('DEVELOPMENT') !== false) {
	$errortypes = E_ALL;
	error_reporting(E_ALL);
}

if (isset($_SETTINGS['DISPLAYERRORS']) && $_SETTINGS['DISPLAYERRORS'] == true) {
	ini_set('display_errors', 1);
} else {
	ini_set('display_errors', 0);
}
ini_set('html_errors', false);

// Log PHP Fatal Errors - Development Servers
if (isset($_SETTINGS['PHPLOG'])) {
	ini_set('log_errors', 1);
	ini_set('error_log', $_SETTINGS['PHPLOG']);
}

// Error Log
if (isset($_SETTINGS['LOGFILE'])) {
	$logfile = $_SETTINGS['LOGFILE'];
} else {
	$logfile = dirname(__FILE__) . '/../log/ERRORLOG.TXT';
}

// Include Path
$dir = dirname(__FILE__);

require_once($dir . '/class.errorhandler.php');

// Version
require_once($dir . '/version.php');

// Composer Auto Loader
require_once($dir . '/../vendor/autoload.php');

// Whoops - Development Error Handling
/*
$whoops = new \Whoops\Run;
$handler = new PrettyPageHandler;

// Chatstack Table
$handler->addDataTable('Chatstack', array(
  'Version' => $_SETTINGS['WEBVERSION'] . ' ' . 'build 7433 release'
));

// Set the title of the error page:
$handler->setPageTitle('Whoops! Chatstack PHP Error');

$whoops->pushHandler($handler);
$whoops->register();
*/

if (!empty($logfile) && is_writable($logfile)) {
	set_error_handler('\\stardevelop\\chatstack\\ErrorHandler::handler', $errortypes);
}

if (!isset($_SETTINGS['DATABASECHARSET']) || !isset($_SETTINGS['DATABASECOLLATION'])) {
	$_SETTINGS['DATABASECHARSET'] = 'utf8';
	$_SETTINGS['DATABASECOLLATION'] = 'utf8_unicode_ci';
}

ini_set('magic_quotes_sybase', 0);

if (version_compare(phpversion(), '7.4.0alpha1', '<') && function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc()) {
	$_COOKIE = array_map('stripslashes', $_COOKIE);
	$_REQUEST = array_map('stripslashes', $_REQUEST);
}

if (!isset($_SERVER['HTTP_REFERER'])){ $_SERVER['HTTP_REFERER'] = ''; }
if (!isset($_REQUEST['COOKIE'])){ $_REQUEST['COOKIE'] = ''; }
if (!isset($_REQUEST['SERVER'])){ $_REQUEST['SERVER'] = ''; }

// Database Table Prefix
if (!defined('TABLEPREFIX') && isset($table_prefix)) {
	define('TABLEPREFIX', $table_prefix);
}

// Settings Model
$settings = false;
require_once($dir . '/class.settings.php');

// Database Configuration
if (defined('DB_HOST') && defined('DB_NAME') && defined('DB_USER') && defined('DB_PASS')) {

	try {

		$capsule = new Capsule;
		
		$connection = [
			'driver' => 'mysql',
			'host' => DB_HOST,
			'database' => DB_NAME,
			'username' => DB_USER,
			'password' => DB_PASS,
			'charset' => $_SETTINGS['DATABASECHARSET'],
			'collation' => $_SETTINGS['DATABASECOLLATION'],
			'prefix' => ''
		];

		if (!defined('DB_SOCKET')) {
			//ORM::configure('mysql:host=' . DB_HOST . ';port=' . DB_PORT . ';dbname=' . DB_NAME . ';charset=' . $_SETTINGS['DATABASECHARSET'], null, 'default');
			$connection['port'] = DB_PORT;
		} else {
			//ORM::configure('mysql:host=' . DB_HOST . ';unix_socket=' . DB_SOCKET . ';dbname=' . DB_NAME . ';charset=' . $_SETTINGS['DATABASECHARSET'], null, 'default');
			$connection['unix_socket'] = DB_SOCKET;
		}

		if (defined('DB_OPTIONS') && is_array(DB_OPTIONS)) {
			//ORM::configure('driver_options', DB_OPTIONS);
			$connection['options'] = DB_OPTIONS;
		}

		//ORM::configure('username', DB_USER, 'default');
		//ORM::configure('password', DB_PASS, 'default');

		// Capsule database connection
		$capsule->addConnection($connection, 'default');

		// Make this Capsule instance available globally via static methods
		$capsule->setAsGlobal();

		// Check Eloquent Connection
		//$capsule::connection()->getPdo();

		// Check MySQL Emoji Support
		//$res = ORM::raw_execute('SELECT VERSION() AS `version`');
		//$statement = ORM::get_last_statement();
		$statement = $capsule::connection()->getPdo()->query('SELECT VERSION() AS `version`');
		$rows = array();
		while ($row = $statement->fetch(\PDO::FETCH_ASSOC)) {
			if (is_array($row)) {
				$version = $row['version'];
				if (!empty($version)) {
					// Check MySQL Minimum Requirement
					$minimum = '5.5.3';
					$version = (strpos($version, '-')) ? substr($version, 0, strpos($version, '-')) : $version;
					if (strnatcmp($version, $minimum) > -1) {
						// MySQL Charset
						$_SETTINGS['DATABASECHARSET'] = 'utf8mb4';
						$_SETTINGS['DATABASECOLLATION'] = 'utf8mb4_bin';

						// Emoji
						$_SETTINGS['EMOJI'] = true;

						// MySQL 
						$connection = [
							'driver' => 'mysql',
							'host' => DB_HOST,
							'database' => DB_NAME,
							'username' => DB_USER,
							'password' => DB_PASS,
							'charset' => $_SETTINGS['DATABASECHARSET'],
							'collation' => $_SETTINGS['DATABASECOLLATION'],
							'prefix' => ''
						];
				
						if (!defined('DB_SOCKET')) {
							//ORM::configure('mysql:host=' . DB_HOST . ';port=' . DB_PORT . ';dbname=' . DB_NAME . ';charset=' . $_SETTINGS['DATABASECHARSET'], null, 'default');
							$connection['port'] = DB_PORT;
						} else {
							//ORM::configure('mysql:host=' . DB_HOST . ';unix_socket=' . DB_SOCKET . ';dbname=' . DB_NAME . ';charset=' . $_SETTINGS['DATABASECHARSET'], null, 'default');
							$connection['unix_socket'] = DB_SOCKET;
						}

						// Capsule database connection
						$capsule->addConnection($connection, 'default');

						// Set the event dispatcher used by Eloquent model
						$capsule->setEventDispatcher(new Dispatcher(new Container));

						// Make this Capsule instance available globally via static methods
						$capsule->setAsGlobal();

						// Setup the Eloquent ORM... (optional; unless you've used setEventDispatcher())
						$capsule->bootEloquent();

					}
				}
			}
		}

		if (!isset($_SETTINGS['DATABASECHARSETOVERRIDE']) || (isset($_SETTINGS['DATABASECHARSETOVERRIDE']) && !$_SETTINGS['DATABASECHARSETOVERRIDE'])) {
			$query = sprintf('SET NAMES %s COLLATE %s', $_SETTINGS['DATABASECHARSET'], $_SETTINGS['DATABASECOLLATION']);
			//ORM::raw_execute($query, array(), 'default');
			if (!empty($connection['options']) && is_array($connection['options'])) {
				$connection['options'][\PDO::MYSQL_ATTR_INIT_COMMAND] = $query;
			} else {
				$connection['options'] = [
					\PDO::MYSQL_ATTR_INIT_COMMAND => $query
				];
			}
		}

	} catch (\PDOException $ex) {
		trigger_error('MySQL Connection Error: ' . $ex->getMessage(), E_USER_WARNING);
		return false;
	}

	// Settings
	$settings = Setting::all();

}

if (isset($_PLUGINS['WHMCS']) && !is_array($_PLUGINS['WHMCS'])) {
	$_PLUGINS['WHMCS'] = array();
}

// WHMCS Database Configuration
if (!empty($_PLUGINS)) {
	foreach ($_PLUGINS as $key => $plugin) {
		if (isset($plugin['DB_HOST']) && isset($plugin['DB_NAME']) && isset($plugin['DB_USER']) && isset($plugin['DB_PASS'])) {

			try {
				if (!isset($plugin['DB_SOCKET'])) {
					ORM::configure('mysql:host=' . $plugin['DB_HOST'] . ';port=' . DB_PORT . ';dbname=' . $plugin['DB_NAME'] . ';charset=' . $_SETTINGS['DATABASECHARSET'], null, $plugin['CONNECTION']);
				} else {
					ORM::configure('mysql:host=' . $plugin['DB_HOST'] . ';unix_socket=' . $plugin['DB_SOCKET'] . ';dbname=' . $plugin['DB_NAME'] . ';charset=' . $_SETTINGS['DATABASECHARSET'], null, $plugin['CONNECTION']);
				}
				ORM::configure('username', $plugin['DB_USER'], $plugin['CONNECTION']);
				ORM::configure('password', $plugin['DB_PASS'], $plugin['CONNECTION']);

				if (!isset($_SETTINGS['DATABASECHARSETOVERRIDE']) || (isset($_SETTINGS['DATABASECHARSETOVERRIDE']) && !$_SETTINGS['DATABASECHARSETOVERRIDE'])) {
					$query = sprintf('SET NAMES %s COLLATE %s', $_SETTINGS['DATABASECHARSET'], $_SETTINGS['DATABASECOLLATION']);
					ORM::raw_execute($query, array(), $plugin['CONNECTION']);
				}

			} catch (\PDOException $ex) {
				return false;
			}

		} else {
			if (is_array($_PLUGINS[$key])) {
				$_PLUGINS[$key]['CONNECTION'] = 'default';
			}
		}
	}
}

// Hooks
require_once $dir . '/class.hooks.php';

// Web Hook
if (!defined('WEBHOOK')) {
	if (!empty($settings)) {
		// Initialize Settings
		Setting::initializeSettings($settings);
		return true;

	} else {
		// Settings Loaded Hook
		$hooks->run('SettingsLoaded', $_SETTINGS);
		return false;
	}
}

?>
