<?php
/*
Chatstack - https://www.chatstack.com
Copyright - All Rights Reserved - Stardevelop Pty Ltd

You may not distribute this program in any manner,
modified or otherwise, without the express, written
consent from Stardevelop Pty Ltd (https://www.chatstack.com)

You may make modifications, but only for your own
use and within the confines of the License Agreement.
All rights reserved.

Selling the code for this program without prior
written consent is expressly forbidden. Obtain
permission before redistributing this program over
the Internet or in any other medium.  In all cases
copyright and header must remain intact.
*/
namespace stardevelop\chatstack;

require_once('./include/database.php');
require_once('./include/class.aes.php');
require_once('./include/class.cookie.php');
require_once('./include/class.session.php');
require_once('./include/class.email.php');
require_once('./include/core.functions.php');
require_once('./include/core.config.php');
require_once('./include/class.models.php');
require_once('./include/class.push.php');

ignore_user_abort(true);

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
	if (isset($_SERVER['HTTP_ORIGIN'])) {
		header('Access-Control-Allow-Origin: ' . $_SERVER['HTTP_ORIGIN']);
		header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
		header('Access-Control-Allow-Headers: X-Requested-With');
		header('Access-Control-Allow-Credentials: true');
		header('Access-Control-Max-Age: 1728000');
		header('Content-Length: 0');
		header('Content-Type: text/plain');
		exit();
	} else {
		header('HTTP/1.1 403 Access Forbidden');
		header('Content-Type: text/plain');
		exit();
	}
} else {
	// AJAX Cross-site Headers
	if (isset($_SERVER['HTTP_ORIGIN'])) {
		header('Access-Control-Allow-Origin: ' . $_SERVER['HTTP_ORIGIN']);
		header('Access-Control-Allow-Credentials: true');
	}
}

header('Content-type: text/html; charset=utf-8');

if (defined('LANGUAGE')) {
	include('./locale/' . LANGUAGE . '/guest.php');
} else {
	include('./locale/en/guest.php');
}

// JSON Request Body
$body = @file_get_contents('php://input');
$data = json_decode($body, true);

if (!empty($data)) {
	// JSON Request Data
	$data = array_change_key_case($data, CASE_UPPER);

	// Session
	$_REQUEST['SESSION'] = (isset($data['SESSION'])) ? $data['SESSION'] : '';

	// Initialise Session
	$session = new Session($_REQUEST['SESSION'], $_SETTINGS['AUTHKEY'], true);

	if (!empty($session->chat)) {
		$chat = $session->chat;
		if (!empty($chat)) {

			if ($chat->status == 1 && $chat->session->count() > 0) {

				// Close Status
				$chat->status = -1;
				$chat->save();

				// Save Session End Datetime
				$chatsession = ChatSession::where('chat', $chat->id)
					->whereNull('end')
					->orderBy('accepted', 'desc')
					->first();

				$endtime = time();
				if (!empty($chatsession)) {
					$chatsession->end = date('Y-m-d H:i:s', $endtime);
					$chatsession->save();
				}

				// Delete Typing
				$typing = Typing::where('chat', $chat->id)->get();
				if (!$typing->isEmpty()) {
					foreach ($typing as $key => $type) {
						$type->delete();
					}
				}

				// Initiate Chat
				if (is_numeric($session->request->id) && $session->request->id > 0) {
					$visitor = $session->request;
					if (!empty($visitor)) {
						$visitor->initiate = 0;
						$visitor->save();
					}
				}

				$hooks->run('VisitorSaveInitiate', array('id' => $session->request->id));

				if ($_SETTINGS['SERVERVERSION'] >= 3.90) {
					// Insert Closed Chat Activity
					$activity = new Activity;
					$activity->user = $chat->id;
					$activity->username = $chat->name;
					$activity->datetime = date('Y-m-d H:i:s', time());
					$activity->activity = 'The chat with {name} has been closed';
					$activity->type = 9;
					$activity->status = 0;
					$activity->save();
				}

				// Close Chat Hook
				$hooks->run('CloseChat', array($chat->id, $chat->name));

				// Send Chat Transcript
				if (isset($_SETTINGS['AUTOEMAILTRANSCRIPT']) && !empty($_SETTINGS['AUTOEMAILTRANSCRIPT'])) {

					$messages = Message::where('chat', $chat->id)
						->where('status', '<=', 3)
						->orderBy('datetime')
						->get();

					// Determine EOL
					$server = strtoupper(substr(PHP_OS, 0, 3));
					if ($server == 'WIN') {
						$eol = "\r\n";
					} elseif ($server == 'MAC') {
						$eol = "\r";
					} else {
						$eol = "\n";
					}

					$htmlmessages = '';
					if (!empty($messages)) {
						foreach ($messages as $key => $message) {
							$content = $message->message;

							switch ($message->status) {
								case -3: // Chat Rating
									break;
								case -2: // Visitor Alert
									// Issue: Outlook 2007 / 2010 doesn't support CSS Float and Position use align attribute instead
									$htmlmessages .= '<img src="' . $_SETTINGS['URL'] . '/livehelp/images/16px/Visitor.png" style="margin-right:5px" align="left" width="16" height="16" /><div style="margin-left:15px; color:#666666;">' . $content . '</div>' . $eol;
									break;
								case 2: // Hyperlink
									list($description, $link) = explode("\n", $content);
									$content = '<a href="' . trim($link) . '" alt="' . trim($description) . '">' . trim($link) . '</a>';
									$htmlmessages .= '<div style="margin-left:15px">' . trim($description) . ' - ' . $content . '</div>' . $eol;
									break;
								case 3: // Image
									list($description, $image) = explode("\n", $content);
									$content = '<img src="' . trim($image) . '" alt="Received Image">';
									$htmlmessages .= '<div style="margin-left:15px">' . $content . '</div>' . $eol;
									break;
								default:
									// Remove HTML code
									$content = str_replace('<', '&lt;', $content);
									$content = str_replace('>', '&gt;', $content);
									$content = preg_replace("/(\r\n|\r|\n)/", '<br />', $content);

									// Emoticons
									$content = htmlSmilies($content, $_SETTINGS['URL'] . '/livehelp/images/16px/', $eol);

									// Operator
									if ($message->status) {
										$htmlmessages .= '<div style="color:#666666">' . $message->username . ' ' . $_LOCALE['says'] . ':</div><div style="margin-left:15px; color:#666666;">' . $content . '</div>' . $eol;
									}
									// Guest
									if (!$message->status) {
										$htmlmessages .= '<div>' . $message->username . ' ' . $_LOCALE['says'] . ':</div><div style="margin-left: 15px;">' . $content . '</div>' . $eol;
									}
									break;
							}
						}
					}

					$visitor = false;
					if (is_numeric($session->request->id) && (int)$session->request->id > 0) {
						$visitor = $session->request;
					}

					$result = $hooks->run('VisitorLoaded', array('id' => $session->request->id, 'visitor' => $visitor));
					if (is_array($result) && isset($result['visitor'])) {
						$visitor = $result['visitor'];
					}

					// Email
					$email = (!empty($chat->email)) ? $chat->email : 'Unavailable';

					$visitorhtml = '';
					if (!empty($visitor)) {

						// Location
						$location = '';
						if (method_exists($visitor, 'geolocation')) {
							$geolocation = $visitor->geolocation->first();
							$city = (!empty($geolocation)) ? $geolocation->city : '';
							$state = (!empty($geolocation)) ? $geolocation->state : '';
							$country = (!empty($geolocation)) ? $geolocation->country : '';
						} else {
							$city = (!empty($visitor->city)) ? $visitor->city : '';
							$state = (!empty($visitor->state)) ? $visitor->state : '';
							$country = (!empty($visitor->country)) ? $visitor->country : '';
						}
						$location = implode(', ', array_filter([$city, $state, $country])) ;

						$visitorhtml = <<<END
<div id="visitor" class="visitor">
<div><span class="label">Hostname / IP Address:</span> <span id="email">{$visitor->ipaddress}</span></div>
<div><span class="label">Email:</span> <span id="email">{$email}</span></div>
<div><span class="label">Web Browser:</span> <span id="useragent">{$visitor->useragent}</span></div>
<div><span class="label">Resolution:</span> <span id="resolution">{$visitor->resolution}</span></div>
<div><span class="label">Country:</span> <span id="location">{$location}</span></div>
<div><span class="label">Referer:</span> <span id="referer">{$visitor->referrer}</span></div>
<div><span class="label">Current Page:</span> <span id="page">{$visitor->url}</span>
<div><span class="label">Page History:</span> <span id="history">{$visitor->path}</span></div>
</div>
END;
					}

					$html = <<<END
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<style type="text/css">
<!--

div, p {
	font-family: Calibri, Verdana, Arial, Helvetica, sans-serif;
	font-size: 14px;
	color: #000000;
	dir: {$_SETTINGS['DIRECTION']};
}
#visitor {
	position: relative;
	margin-top: 25px;
}
.label {
	color: #666666;
}

//-->
</style>
</head>

<body>
<div><img src="{$_SETTINGS['CHATTRANSCRIPTHEADERIMAGE']}" alt="{$_LOCALE['chattranscript']}" /></div>
<div><strong>{$_LOCALE['chattranscript']}:</strong></div>
<div>$htmlmessages</div>
$visitorhtml
<div style="position:relative; margin-top:25px"><img src="{$_SETTINGS['CHATTRANSCRIPTFOOTERIMAGE']}" alt="{$_SETTINGS['NAME']}" /></div>
</body>
</html>
END;

					if (!empty($htmlmessages)) {

						$from = $_SETTINGS['EMAIL'];
						if (isset($_SETTINGS['SMTPFROM'])) {
							$from = $_SETTINGS['SMTPFROM'];
						}

						$datetime = date('l jS F Y H:i:s', $endtime);
						$subject = $_SETTINGS['NAME'] . ' ' . $_LOCALE['chattranscript'] . ' (' . $_LOCALE['autogenerated'] . ') - ' . $datetime;
						$result = Email::send($_SETTINGS['AUTOEMAILTRANSCRIPT'], $from, $_SETTINGS['NAME'], $subject, $html, EmailType::HTML);
					}
				}
			}
		}
	}

}

?>
