 <?php
/**
* @version		$Id: mod_liveelp.php 10381 2010-04-20 03:35:53Z stardevelop.com $
* @package		Live Help
* @copyright	Copyright (C) 2003 - 2013 Stardevelop Pty Ltd. All rights reserved.
* @license		Commercial License
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/

// Block Direct Access
defined('_JEXEC') or die('Restricted access');

// Include the syndicate functions only once
require_once (dirname(__FILE__) . DIRECTORY_SEPARATOR . 'helper.php');

// Default Site URL
if ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == '443') {	$protocol = 'https://'; } else { $protocol = 'http://'; }
$host = $protocol . $_SERVER['HTTP_HOST'] . '/livehelp/';

// Settings
$url = $params->get('url', $host);
$library = $params->get('insert-library', 1);
$embedded = $params->get('embedded', 1);

// HTML Head / Scripts
$document = JFactory::getDocument();
$head = $document->getHeadData();
$scripts = $head['scripts'];

// Remove Protocol
$protocols = array('http://', 'https://');
$url = str_replace($protocols, '', $url);

// Add JavaScript
if (!defined('LiveHelpJavaScriptInserted')) {

	// JavaScript Settings
	$settingsjs = 'var Chatstack = { server: \'' . $url . '\' };' . "\n";

	// Embedded Chat
	/*
	if ($embedded !== true) {
		$settingsjs .= 'Chatstack.embedded = false;' . "\n";
	}
	*/

	$document->addScriptDeclaration($settingsjs);

	$javascript = '(function(d, undefined) {' . "\n";
	$javascript .= '	Chatstack.e = []; Chatstack.ready = function (c) { Chatstack.e.push(c); }' . "\n";
	$javascript .= '	Chatstack.server = Chatstack.server.replace(/[a-z][a-z0-9+\-.]*:\/\/|\/livehelp\/*(\/|[a-z0-9\-._~%!$&\'()*+,;=:@\/]*(?![a-z0-9\-._~%!$&\'()*+,;=:@]))|\/*$/g, \'\');' . "\n";
	$javascript .= '	var b = document.createElement(\'script\'); b.type = \'text/javascript\'; b.async = true;' . "\n";
	$javascript .= '	b.src = (\'https:\' == document.location.protocol ? \'https://\' : \'http://\') + Chatstack.server + \'/livehelp/scripts/js.min.js\';' . "\n";
	$javascript .= '	var s = document.getElementsByTagName(\'script\')[0];' . "\n";
	$javascript .= '	s.parentNode.insertBefore(b, s);' . "\n";
	$javascript .= '})(document);' . "\n";
	$document->addScriptDeclaration($javascript);

	define('LiveHelpJavaScriptInserted', true);
}

$layout = JModuleHelper::getLayoutPath('mod_livehelp');
require($layout);
