<?php
namespace stardevelop\chatstack;

error_reporting(E_ALL);

ini_set('display_errors', 1);
ini_set('html_errors', false);

require dirname(__FILE__) . '/vendor/autoload.php';

use GeoIp2\Database\Reader;


class GeoIP2 {

	// Location
	static function location($ipaddress) {
		// MaxMind Database
		$database = '/data/GeoLite2-City.mmdb';
		if (file_exists(dirname(__FILE__) . '/data/GeoIP2-City.mmdb')) {
			$database = '/data/GeoIP2-City.mmdb';
		}

		// Open MaxMind Database
		$reader = new Reader(dirname(__FILE__) . $database);
		try {
			$record = $reader->city($ipaddress);
		} catch (\GeoIp2\Exception\AddressNotFoundException $ex) {
			return false;
		}
		return $record;
	}

}

?>