<?php
namespace stardevelop\chatstack\Plugins\WHMCS;

use Illuminate\Database\Eloquent\Model as Eloquent;

/*
Chatstack - https://www.chatstack.com
Copyright - All Rights Reserved - Stardevelop Pty Ltd

You may not distribute this program in any manner,
modified or otherwise, without the express, written
consent from Stardevelop Pty Ltd (https://www.chatstack.com)

You may make modifications, but only for your own
use and within the confines of the License Agreement.
All rights reserved.

Selling the code for this program without prior
written consent is expressly forbidden. Obtain
permission before redistributing this program over
the Internet or in any other medium.  In all cases
copyright and header must remain intact.
*/

class Admin extends Eloquent {
	protected $table = 'tbladmins';
	protected $connection = 'default';

	public $timestamps = false;
}
// TODO Set MySQL connection
// $_PLUGINS['WHMCS']['CONNECTION']

class TicketDepartment extends Eloquent {
	protected $table = 'tblticketdepartments';
	protected $connection = 'default';

	public $timestamps = false;
}


class TicketPredefinedReplyCategory extends Eloquent {
	protected $table = 'tblticketpredefinedcats';
	protected $connection = 'default';

	public $timestamps = false;
}


class TicketPredefinedReply extends Eloquent {
	protected $table = 'tblticketpredefinedreplies';
	protected $connection = 'default';

	public $timestamps = false;

	public function category() {
		return $this->hasOne('\stardevelop\chatstack\Plugins\WHMCS\TicketPredefinedReplyCategory', 'id', 'id');
	}
}


class Setting extends Eloquent {
	protected $table = 'tblconfiguration';
	protected $connection = 'default';
	protected $primaryKey = 'setting';

	public $timestamps = false;
}


class Ticket extends Eloquent {
	protected $table = 'tbltickets';
	protected $connection = 'default';

	public $timestamps = false;
}


class TicketReply extends Eloquent {
	protected $table = 'tblticketreplies';
	protected $connection = 'default';

	public $timestamps = false;
}


class KnowledgebaseCategory extends Eloquent {
	protected $table = 'tblknowledgebasecats';
	protected $connection = 'default';

	public $timestamps = false;
}


class KnowledgebaseLink extends Eloquent {
	protected $table = 'tblknowledgebaselinks';
	protected $connection = 'default';

	public $timestamps = false;

	public function knowledgebase() {
		return $this->hasOne('\stardevelop\chatstack\Plugins\WHMCS\Knowledgebase', 'id', 'articleid');
	}
}


class Knowledgebase extends Eloquent {
	protected $table = 'tblknowledgebase';
	protected $connection = 'default';

	public $timestamps = false;
}


class Client extends Eloquent {
	protected $table = 'tblclients';
	protected $connection = 'default';

	public $timestamps = false;

	public function securityquestion() {
		return $this->hasOne('\stardevelop\chatstack\Plugins\WHMCS\SecurityQuestion', 'id', 'securityqid');
	}

	public function hosting() {
		return $this->hasMany('\stardevelop\chatstack\Plugins\WHMCS\Hosting', 'userid', 'id');
	}
}

class User extends Eloquent {
	protected $table = 'tblusers';
	protected $connection = 'default';

	public $timestamps = false;

	public function securityquestion() {
		return $this->hasOne('\stardevelop\chatstack\Plugins\WHMCS\SecurityQuestion', 'id', 'security_question_id');
	}
}


class SecurityQuestion extends Eloquent {
	protected $table = 'tbladminsecurityquestions';
	protected $connection = 'default';

	public $timestamps = false;
}


class Hosting extends Eloquent {
	protected $table = 'tblhosting';
	protected $connection = 'default';

	public $timestamps = false;

	public function product() {
		return $this->hasOne('\stardevelop\chatstack\Plugins\WHMCS\Product', 'id', 'packageid');
	}
}


class Product extends Eloquent {
	protected $table = 'tblproducts';
	protected $connection = 'default';

	public $timestamps = false;

	public function group() {
		return $this->hasOne('\stardevelop\chatstack\Plugins\WHMCS\ProductGroup', 'id', 'gid');
	}
}


class ProductGroup extends Eloquent {
	protected $table = 'tblproductgroups';
	protected $connection = 'default';

	public $timestamps = false;
}


?>
