<?php
/*
Chatstack - https://www.chatstack.com
Copyright - All Rights Reserved - Stardevelop Pty Ltd

You may not distribute this program in any manner,
modified or otherwise, without the express, written
consent from Stardevelop Pty Ltd (https://www.chatstack.com)

You may make modifications, but only for your own
use and within the confines of the License Agreement.
All rights reserved.

Selling the code for this program without prior
written consent is expressly forbidden. Obtain
permission before redistributing this program over
the Internet or in any other medium.  In all cases
copyright and header must remain intact.
*/
namespace stardevelop\chatstack;

use WHMCS\Security\Hash\Password;
use WHMCS\Authentication\CurrentUser;

if (isset($_PLUGINS) && isset($_PLUGINS['WHMCS'])) {
  require_once dirname(__FILE__) . '/../functions.php';
  require_once dirname(__FILE__) . '/../../../include/class.passwordhash.php';
  require_once dirname(__FILE__) . '/../class.models.php';
}


/*
 * Hook class name must end with Hooks
 * i.e. ExampleHooks or TestHooks
 *
 */
class LiveHelpWHMCSHooks {

  function __construct() {
    // Init Hook
  }

  function CloseChat($args) {

    global $_SETTINGS;

    // Arguments
    list($chat, $name) = $args;

    if ($name === false) {
      return;
    }

    if (isset($_SETTINGS['WHMCSTICKETS']) && $_SETTINGS['WHMCSTICKETS'] == false) {
      return false;
    }

    // Close Chat Event
    $chat = Chat::where('id', $chat)
      ->orderBy('id')
      ->first();

    $session = false;
    if (empty($chat->request)) {
      $visitor = ChatVisitor::where('chat', $chat->id)->first();
      if (!empty($visitor)) {
        $custom = $visitor->custom->first();
        if (!empty($custom)) {
          $session = $custom->custom;
        }
      }
    } else {
      if (!empty($chat)) {
        $custom = $chat->custom->first();
        if (!empty($custom)) {
          $session = $custom->custom;
        }
      }
    }

    if (!empty($session)) {
      
      $client = Plugins\WHMCS\Client::where('email', $session)->first();
      if (!empty($client)) {

        // Log Chat Ticket
        $seeds = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $c = null;
        $seeds_count = strlen($seeds) - 1;
        for ($i = 0; 8 > $i; $i++) {
          $c .= $seeds[rand(0, $seeds_count)];
        }

        $ticketdepartment = false;
        if (!empty($chat->department)) {
          // Find Department
          $ticketdepartment = Plugins\WHMCS\TicketDepartment::where('name', $chat->department)->first();
        } else {
          // Default Department
          $ticketdepartment = Plugins\WHMCS\TicketDepartment::where('hidden', '')
            ->orderBy('order')
            ->get();
        }

        if (!empty($ticketdepartment) && !$ticketdepartment->isEmpty()) {
          $department = $ticketdepartment->id;

          // Chat Transcript
          $messages = Message::where('chat', $chat->id)
            ->where('status', '<=', 3)
            ->orderBy('datetime')
            ->get();

          $transcript = ''; $textmessages = '';
          $names = array();

          // Determine EOL
          $server = strtoupper(substr(PHP_OS, 0, 3));
          if ($server == 'WIN') {
            $eol = "\r\n";
          } elseif ($server == 'MAC') {
            $eol = "\r";
          } else {
            $eol = "\n";
          }

          // Language
          $language = file_get_contents(dirname(__FILE__) . '/../../../locale/en/admin.json');
          if (file_exists(dirname(__FILE__) . '/../../../locale/' . LANGUAGE . '/admin.json')) {
            $language = file_get_contents(dirname(__FILE__) . '/../../../locale/' . LANGUAGE . '/admin.json');
          }
          $_LOCALE = json_decode($language, true);

          $transcript .= '[div="chat"]';
          if (!empty($messages) && !$messages->isEmpty()) {
            foreach ($messages as $key => $message) {
              $status = (int)$message->status;
              // Operator
              if ($status) {

                if (!empty($message->username) && !array_key_exists($message->username, $names)) {
                  // Operator
                  $user = Operator::where('username', $message->username)->first();
                  if (!empty($user)) {
                    $names[$message->username] = $user->firstname;
                  }
                }

                if (!empty($message->username)) {
                  $transcript .= '[div="operator"][div="name"]' . $names[$message->username] . ' says:[/div][div="message"]' . $message->message . '[/div][/div]';
                  $textmessages .= $names[$message->username] . ' ' . $_LOCALE['says'] . ':' . $eol . '	' . $message->message . $eol;
                } else {
                  $transcript .= '[div="operator"][div="message"]' . $message->message . '[/div][/div]';
                  $textmessages .= $message->message . $eol;
                }
              }

              // Guest
              if (!$status) {

                // Replace HTML Code
                $content = str_replace('<', '&lt;', $message->message);
                $content = str_replace('>', '&gt;', $content);

                $transcript .= '[div="visitor"][div="name"]' . $message->username . ' says:[/div][div="message"]' . $content . '[/div][/div]';
                $textmessages .= $message->username . ' ' . $_LOCALE['says'] . ':' . $eol . '	' . $content . $eol;
              }
            }
          }
          $transcript .= '[/div]';
          $transcript = preg_replace("/(\r\n|\r|\n)/", '<br/>', $transcript);

          // Date Format
          $dateformat = 'd/m/Y H:i';
          $setting = Plugins\WHMCS\Setting::find('DateFormat');
          if (!empty($setting) && $setting->value === 'MM/DD/YYYY') {
            $dateformat = 'm/d/Y H:i';
          }

          $datetime = date('Y-m-d H:i:s', time());

          // Insert Live Help Chat
          $ticket = new Plugins\WHMCS\Ticket;
          $ticket->did = $department;
          $ticket->userid = $client->id;
          $ticket->contactid = 0;
          $ticket->name = '';
          $ticket->email = '';
          $ticket->cc = '';
          $ticket->c = $c;
          $ticket->date = $datetime;
          $ticket->title = sprintf('Chat Log %s', date($dateformat));
          $ticket->message = $transcript;
          $ticket->status = 'Closed';
          $ticket->urgency = 'Medium';
          $ticket->admin = '';
          $ticket->attachment = '';
          $ticket->adminunread = '';
          $ticket->service = '';
          $ticket->lastreply = $datetime;

          // WHMCS Version
          $setting = Plugins\WHMCS\Setting::find('Version');
          if (!empty($setting) && version_compare($setting->value, '6.3.0') >= 0) {
            $ticket->editor = 'bbcode';
          }

          $ticket->save();

          // WHMCS Ticket Masking
          $mask = Plugins\WHMCS\genTicketMask($ticket->id);

          $ticket->tid = $mask;
          $ticket->save();

        }
      }
    }
  }


  function ResponsesCustom($format) {

    // KB URL
    $whmcs = Plugins\WHMCS\whmcsURL(false);
    $kburl = $whmcs . 'knowledgebase.php?action=displayarticle&id=';

    if ($format == 'json') {

      // Custom Responses
      $custom = array();
      $other = array();

      // Output Knowledge Base Links
      $categories = Plugins\WHMCS\KnowledgebaseCategory::where('hidden', '!=', 'on')->get();
      if (!empty($categories) && !$categories->isEmpty()) {
        $custom = array();

        foreach ($categories as $key => $category) {
          // KB Links
          $knowledgebaselinks = Plugins\WHMCS\KnowledgebaseLink::where('categoryid', $category->id)->get();
          if (!empty($knowledgebaselinks) && !$knowledgebaselinks->isEmpty()) {
            foreach ($knowledgebaselinks as $key => $link) {
              // Knowledgebase Article
              $article = $link->knowledgebase;
              if (!empty($article)) {
                // WHMCS Knowledgebase Link
                $custom[] = array('ID' => $article->id, 'Name' => $article->title, 'Content' => $kburl . $article->id, 'Category' => $category->name, 'Type' => 2);
              }
            }
          }
        }
      }

      // Ticket Responses
      $ticketreplies = Plugins\WHMCS\TicketPredefinedReply::all();
      if (!empty($ticketreplies)) {
        foreach ($ticketreplies as $key => $reply) {
          // Category
          if (!empty($reply->category)) {
            // Predefined Reply with Category
            $category = $reply->category;
            $custom[] = array('ID' => $reply->id, 'Name' => $reply->name, 'Content' => $reply->reply, 'Category' => $category->name, 'Type' => 1);
          } else {
            // Predefined Reply
            $custom[] = array('ID' => $reply->id, 'Name' => $reply->name, 'Content' => $reply->reply, 'Type' => 1);
          }
        }
      }

      if (!empty($custom)) {
        $other[] = array('Custom' => $custom);
      }

      return $other;

    } else {

      // Output Knowledge Base Links
      $categories = Plugins\WHMCS\KnowledgebaseCategory::where('hidden', '!=', 'on')->get();
      if (!empty($categories) && !$categories->isEmpty()) {
?>
    <Custom Description="WHMCS Knowledgebase">
<?php

        foreach ($categories as $key => $category) {

          // KB Links
          $knowledgebaselinks = Plugins\WHMCS\KnowledgebaseLink::where('categoryid', $category->id)->get();
          if (!empty($knowledgebaselinks) && !$knowledgebaselinks->isEmpty()) {
?>
      <Category Name="<?php echo($category->name); ?>">
<?php
            foreach ($knowledgebaselinks as $key => $link) {

              // Knowledgebase Article
              $article = $link->knowledgebase->first();
              if (!empty($article)) {
?>
        <Response ID="<?php echo($article->id); ?>" Type="Hyperlink">
          <Name><?php echo(xmlelementinvalidchars($article->title)); ?></Name>
          <Content><?php echo(xmlelementinvalidchars($kburl . $article->id)); ?></Content>
          <Tags/>
        </Response>
<?php
              }
            }

?>
      </Category>
<?php
          }
        }
?>
    </Custom>
<?php
        // Ticket Responses
        $ticketreplies = Plugins\WHMCS\TicketPredefinedReply::all();
        if (!empty($ticketreplies)) {
?>
    <Custom Description="WHMCS Predefined Ticket Replies">
<?php
          foreach ($ticketreplies as $key => $reply) {
?>
      <Response ID="<?php echo($reply->id); ?>" Type="Text">
        <Name><?php echo(xmlelementinvalidchars($reply->name)); ?></Name>
        <Content><?php echo(xmlelementinvalidchars($reply->reply)); ?></Content>
        <Tags/>
      </Response>
<?php
          }
?>
    </Custom>
<?php
        }
      }
    }
  }

  function LoginCustomHash($data) {

    $password = $data['Password'];
    $version = $data['Version'];

    if (is_numeric($version) && $version >= 4.0) {
      $password = md5(htmlspecialchars($password));
    }
    return $password;
  }

  function LoginCompleted($_OPERATOR) {

    global $_PLUGINS;

    // WHMCS Plugin
    if (isset($_PLUGINS) && isset($_PLUGINS['WHMCS']) && isset($_REQUEST['Username']) && isset($_REQUEST['Password'])) {

      // Username Special Characters
      if (isset($_REQUEST['Version']) && $_REQUEST['Version'] >= 4.0) {
        $username = htmlspecialchars($_OPERATOR['USERNAME'], ENT_QUOTES);
      }

      $user = Plugins\WHMCS\Admin::where('username', $username)->first();
      if (!empty($user)) {

        $username = $_REQUEST['Username'];
        $password = $_REQUEST['Password'];

        // MD5 Password Hash
        if (isset($_REQUEST['Version']) && $_REQUEST['Version'] >= 4.0) {
          $password = md5(htmlspecialchars($password));
        }

        $validhash = false;
        if (class_exists('WHMCS\\Security\\Hash\\Password') || class_exists('WHMCS_Security_Hash_Password')) {
          if (class_exists('WHMCS\\Security\\Hash\\Password')) {
            $whmcshasher = new Password();
          } else {
            $whmcshasher = new \WHMCS_Security_Hash_Password();
          }
          $validhash = $whmcshasher->verify($password, $user->password);
          if ($validhash){
            // Valid WHMCS Admin
            // Generate Live Help Hash for subsequent login attempts
            $livehelphasher = new PasswordHash(8, true);
            $password = $_REQUEST['Password'];
            $hash = $livehelphasher->HashPassword($password);
          }
        } else {
          // Old Hashing prior to WHMCS 5.3.9
          $validhash = ($user->password == $password);
        }

        if ($validhash) {
          $departments = explode(',', $user->supportdepts);

          $departmnts = array();
          foreach ($departments as $key => $id) {
            $department = Plugins\WHMCS\TicketDepartment::find($id);
            if (!empty($department)) {
              $departmnts[] = $department->name;
            }
          }
          $department = implode('; ', $departmnts);

          $firstname = htmlspecialchars_decode($user->firstname, ENT_QUOTES);
          $lastname = htmlspecialchars_decode($user->lastname, ENT_QUOTES);

          // Update Account
          $operator = Operator::find($_OPERATOR['ID']);
          if (!empty($operator)) {
            $operator->username = $username;
            $operator->password = $hash;
            $operator->firstname = $firstname;
            $operator->lastname = $lastname;
            $operator->email = $user->email;
            $operator->department = $department;
            $operator->custom = $user->id;
            $operator->save();
          }

          $_OPERATOR['USERNAME'] = $user->username;
          $_OPERATOR['PASSWORD'] = $user->password;
          $_OPERATOR['NAME'] = (!empty($lastname)) ? $firstname . ' ' . $lastname : $firstname;
          $_OPERATOR['DEPARTMENT'] = $department;
          return $_OPERATOR;
        }
      } else {

        $operator = Operator::find($_OPERATOR['ID']);
        if (!empty($operator)) {
          $_OPERATOR['USERNAME'] = $operator->username;
          $_OPERATOR['PASSWORD'] = $operator->password;
          $_OPERATOR['NAME'] = (!empty($operator->lastname)) ? $operator->firstname . ' ' . $operator->lastname : $operator->firstname;
          $_OPERATOR['DEPARTMENT'] = $operator->department;
        }

        return $_OPERATOR;
      }
    }
    return $_OPERATOR;
  }

  function LoginFailed($data) {

    global $_SETTINGS;

    $_OPERATOR = $data['Operator'];
    $password = $data['Password'];

    // Sync WHMCS Account
    $user = Plugins\WHMCS\Admin::where('username', $_OPERATOR['USERNAME'])->first();
    if (!empty($user)) {

      $validhash = false;
      if (class_exists('WHMCS\\Security\\Hash\\Password') || class_exists('WHMCS_Security_Hash_Password')) {
        if (class_exists('WHMCS\\Security\\Hash\\Password')) {
          $whmcshasher = new Password();
        } else {
          $whmcshasher = new \WHMCS_Security_Hash_Password();
        }
        $validhash = $whmcshasher->verify($password, $user->password);
        if ($validhash){
          // Valid WHMCS Admin
          // Generate Live Help Hash for subsequent login attempts
          $livehelphasher = new PasswordHash(8, true);
          $hash = $livehelphasher->HashPassword($password);
        }
      } else {
        // Old Hashing prior to WHMCS 5.3.9
        $validhash = ($user->password == $password);
      }

      if ($validhash) {
        $departments = explode(',', $user->supportdepts);

        $departmnts = array();
        foreach ($departments as $key => $id) {
          $department = Plugins\WHMCS\TicketDepartment::find($id);
          if (!empty($department)) {
            $departmnts[] = $department->name;
          }
        }
        $department = implode('; ', $departmnts);

        // Update Account
        $operator = Operator::find($_OPERATOR['ID']);
        if (!empty($operator)) {
          $operator->username = $user->username;
          $operator->password = $user->password;
          $operator->firstname = $user->firstname;
          $operator->lastname = $user->lastname;
          $operator->email = $user->email;
          $operator->department = $department;
          $operator->custom = $user->id;
          $operator->save();
        }

        $_OPERATOR['USERNAME'] = $user->username;
        $_OPERATOR['PASSWORD'] = $user->password;
        $_OPERATOR['NAME'] = (!empty($user->lastname)) ? $user->firstname . ' ' . $user->lastname : $user->firstname;
        $_OPERATOR['DEPARTMENT'] = $department;
        return $_OPERATOR;
      }

    }

    return $_OPERATOR;
  }

  function LoginAccountMissing($data) {

    global $_SETTINGS;

    $username = $data['Username'];
    $password = $data['Password'];

    // Username Special Characters / MD5 Password Hash
    if (isset($_REQUEST['Version']) && $_REQUEST['Version'] >= 4.0) {
      $username = htmlspecialchars($username, ENT_QUOTES);
      $password = md5(htmlspecialchars($password));
    }

    // WHMCS Account
    $user = Plugins\WHMCS\Admin::where('username', $username)->first();
    if (!empty($user)) {

      // Departments
      $departments = explode(',', $user->supportdepts);
      $departmnts = array();
      foreach ($departments as $key => $id) {
        $department = Plugins\WHMCS\TicketDepartment::find($id);
        if (!empty($department)) {
          $departmnts[] = $department->name;
        }
      }
      $department = implode('; ', $departmnts);

      $validhash = false;
      if (class_exists('WHMCS\\Security\\Hash\\Password') || class_exists('WHMCS_Security_Hash_Password')) {
        if (class_exists('WHMCS\\Security\\Hash\\Password')) {
          $whmcshasher = new Password();
        } else {
          $whmcshasher = new \WHMCS_Security_Hash_Password();
        }
        $validhash = $whmcshasher->verify($password, $user->password);
        if ($validhash){
          // Valid WHMCS Admin
          // Generate Live Help Hash for subsequent login attempts
          $livehelphasher = new PasswordHash(8, true);
          $password = $data['Password'];
          $hash = $livehelphasher->HashPassword($password);
        }
      } else {
        // Old Hashing prior to WHMCS 5.3.9
        $validhash = ($user->password == $password);
      }

      // Operator Password
      if ($validhash) {

        // Existing Operator
        $operator = Operator::where('custom', $user->id)->first();

        $firstname = htmlspecialchars_decode($user->firstname, ENT_QUOTES);
        $lastname = htmlspecialchars_decode($user->lastname, ENT_QUOTES);

        if (!empty($operator)) {

          $operator->username = $data['Username'];
          $operator->password = $hash;
          $operator->firstname = $firstname;
          $operator->lastname = $lastname;
          $operator->email = $user->email;
          $operator->department = $department;
          $operator->save();

        } else {

          $operator = new Operator;
          $operator->username = $data['Username'];
          $operator->password = $hash;
          $operator->firstname = $firstname;
          $operator->lastname = $lastname;
          $operator->datetime = date('Y-m-d H:i:s', time());
          $operator->refresh = date('Y-m-d H:i:s', time());
          $operator->updated = date('Y-m-d H:i:s', time());
          $operator->email = $user->email;
          $operator->department = $department;
          $operator->image = '';
          $operator->privilege = -1;
          $operator->status = -1;
          $operator->custom = $user->id;
          $operator->save();

        }

        $_OPERATOR['ID'] = $operator->id;
        $_OPERATOR['USERNAME'] = $operator->username;
        $_OPERATOR['PASSWORD'] = $operator->password;
        $_OPERATOR['NAME'] = (!empty($operator->lastname)) ? $operator->firstname . ' ' . $operator->lastname : $operator->firstname;
        $_OPERATOR['DEPARTMENT'] = $operator->department;
        $_OPERATOR['DATETIME'] = $operator->datetime;
        $_OPERATOR['PRIVILEGE'] = $operator->privilege;
        $_OPERATOR['STATUS'] = $operator->status;
        return $_OPERATOR;

      }
    }

    return false;
  }

  function SettingsLoaded($_SETTINGS = false) {

    global $_SETTINGS;

    if (!empty($settings)) {
      $_SETTINGS = $settings;
    }

    $config = array();
    $settings = Plugins\WHMCS\Setting::all();
    if (!empty($settings)) {
      foreach ($settings as $key => $setting) {
        $config[$setting->setting] = $setting->value;
      }
    }

    $domain = '';
    if (!empty($config['SystemSSLURL'])) {
      $domain = trim($config['SystemSSLURL']);
    } else {
      $domain = trim($config['SystemURL']);
    }
    if (substr($domain, -1) != '/') { $domain = $domain . '/'; }

    $host = str_replace(array('http://', 'https://'), '', $domain);

    $_SETTINGS['HTMLHEAD'] = <<<END
<!-- START chatstack.com Live Chat HTML Code -->
<script type="text/javascript">
<!--
  var Chatstack = { server: '{$host}' };
  (function(d, undefined) {
    // JavaScript
    Chatstack.e = []; Chatstack.ready = function (c) { Chatstack.e.push(c); }
    var b = d.createElement('script'); b.type = 'text/javascript'; b.async = true;
    b.src = ('https:' == d.location.protocol ? 'https://' : 'http://') + Chatstack.server + '/livehelp/scripts/js.min.js';
    var s = d.getElementsByTagName('script')[0];
    s.parentNode.insertBefore(b, s);
  })(document);
-->
</script>
<!-- END chatstack.com Live Chat HTML Code -->
END;

    $_SETTINGS['HTMLBODY'] = '';

    $_SETTINGS['HTMLIMAGE'] = <<<END
<!-- START chatstack.com Live Chat HTML Code -->
<a href="#" class="LiveHelpButton default"><img src="{$domain}modules/livehelp/status.php" id="LiveHelpStatusDefault" name="LiveHelpStatusDefault" border="0" alt="Live Help" class="LiveHelpStatus"/></a>
<!-- END chatstack.com Live Chat HTML Code -->
END;

    return $_SETTINGS;

  }

  function SettingsPlugin() {

    global $customadminpath;

?>
<Plugin ID="WHMCS">
<?php
    // WHMCS SSL URL
    $setting = Plugins\WHMCS\Setting::find('SystemSSLURL');
    $address = $setting->value;
    if (!$setting || empty($setting->value)) {
      $setting = Plugins\WHMCS\Setting::find('SystemURL');
      $address = $setting->value;
    }

    if (substr($address, -1) != '/') {
      $address = $address . '/';
    }

    require_once __DIR__ . '/../../../../../configuration.php';

    if (!isset($customadminpath) && empty($customadminpath)) { $customadminpath = 'admin'; }
    $address .= $customadminpath . '/';
?>
<QuickLinks Address="<?php echo($address); ?>">
<Link Name="Summary" Image="card-address">clientssummary.php?userid={0}</Link>
<Link Name="Orders" Image="shopping-basket">orders.php?client={0}</Link>
<Link Name="Products / Services" Image="box">clientshosting.php?userid={0}</Link>
<Link Name="Domains" Image="globe-medium-green">clientsdomains.php?userid={0}</Link>
<Link Name="Invoices" Image="document-invoice">clientsinvoices.php?userid={0}</Link>
<Link Name="Add Order" Image="shopping-basket--plus">ordersadd.php?userid={0}</Link>
<Link Name="Create Invoice" Image="document--plus">invoices.php?action=createinvoice&amp;userid={0}</Link>
<Link Name="Quotes" Image="documents-text">clientsquotes.php?userid={0}</Link>
<Link Name="Tickets" Image="ticket">supporttickets.php?view=any&amp;client={0}</Link>
<Link Name="Emails" Image="mail-open-document">clientsemails.php?userid={0}</Link>
</QuickLinks>
</Plugin>
<?php
  }

  function VisitorCustomDetails($visitor) {

    global $_OPERATOR;

    // Custom Integration Details
    $custom = Custom::where('request', $visitor->id)->first();
    if (!empty($custom)) {

      // Reference
      $reference = $custom->reference;

      // Client
      $client = false;
      if (is_string($visitor->email)) { // TODO Validate if email address
        $client = Plugins\WHMCS\Client::where('email', $visitor->email)->first();
      } else if (is_numeric($custom->data)) {
        $client = Plugins\WHMCS\Client::find($custom->data);
      }

      if (!empty($client)) {

        // Name
        if (empty($visitor->name)) {
          $visitor->name = $client->firstname . ' ' . $client->lastname;
        }

        // Email
        if (empty($visitor->email)) {
          $visitor->email = $client->email;
        }

        // Reference
        $visitor->reference = $reference;

        // Address
        $address = new Address();
        $address->address1 = $client->address1;
        $address->address2 = $client->address2;
        $address->city = $client->city;
        $address->state = $client->state;
        $address->postcode = $client->postcode;
        $country = Country::find($client->country);
        if (!empty($country)) {
          $address->country = ucwords(strtolower($country->country));
        }

        $visitor->company = html_entity_decode($client->companyname);
        $visitor->address = $address;
        $visitor->telephone = $client->phonenumber;

        $group = new VisitorGroup();
        $group->id = 'whmcs';
        $group->name = 'WHMCS';
        $group->position = 'address';

        // Products & Services
        $section = new VisitorSection();
        $section->id = 'products';
        $section->name = 'Products & Services';
        $hosting = $client->hosting;
        if (!empty($hosting)) {
          foreach ($hosting as $key => $plan) {
            $product = $plan->product;
            if (!empty($product)) {
              $productgroup = $product->group;
              if (!empty($productgroup)) {
                $item = new VisitorItem();
                $item->value = sprintf('%s, %s (%s)', $product->name, $productgroup->name, $plan->domain);
                $section->items[] = $item;
              }
            }
          }
        }
        $group->sections[] = $section;

        // Notes
        $section = new VisitorSection();
        $section->id = 'notes';
        $section->name = 'Notes';

        $item = new VisitorItem();
        $item->value = $client->notes;
        $section->items[] = $item;
        $group->sections[] = $section;

        // Security Question
        if ($client->securityqid > 0) {
          $securityquestion = $client->securityquestion->question;
          $securityanswer = $client->securityqans;
        } else if (is_numeric($custom->custom)) {
          $user = Plugins\WHMCS\User::find($custom->custom);
          $securityquestion = $user->securityquestion->question;
          $securityanswer = $user->security_question_answer;
        }
  
        if (!empty($securityquestion)) {
          $securityquestion = Plugins\WHMCS\decryptPassword($securityquestion, $_OPERATOR['USERNAME']);
          $securityanswer = Plugins\WHMCS\decryptPassword($securityanswer, $_OPERATOR['USERNAME']);
          if (!empty($securityquestion) && !empty($securityanswer)) {

            $section = new VisitorSection();
            $section->id = 'securityquestion';
            $section->name = 'Security Question';

            $item = new VisitorItem();
            $item->value = $securityquestion;
            $section->items[] = $item;
            $group->sections[] = $section;

            $section = new VisitorSection();
            $section->id = 'securityanswer';
            $section->name = 'Security Answer';

            $item = new VisitorItem();
            $item->value = $securityanswer;
            $section->items[] = $item;
            $group->sections[] = $section;
          }
        }

        $visitor->groups[] = $group;
        $visitor->custom = $client->id;
      }
      return $visitor;
    }

    return false;
  }

  function DepartmentsLoaded($departments) {

    $departs = $departments;
    $departments = array();
    if (is_array($departs)) {
      foreach ($departs as $key => $department) {
        // WHMCS Department
        $ticketdepartment = Plugins\WHMCS\TicketDepartment::where('name', $department)->first();
        if (!empty($ticketdepartment)) {
          if ($ticketdepartment->hidden != 'on') {
            $departments[] = $ticketdepartment->name;
          }
        } else {
          $departments[] = $department;
        }
      }
      sort($departments);
      return $departments;
    }
    return $departs;
  }

  function VisitorCustomDetailsInitialised($args) {

    global $_SETTINGS;

    // Arguments
    $request = $args['request'];
    $custom = $args['custom'];
    $plugin = $args['plugin'];

    // Confirm Numeric ID
    if ($plugin == 'WHMCS') {

      // WHMCS Account Name
      if (empty($name)) {

        // Client
        $client = false;
        if (is_string($custom)) {
          $client = Plugins\WHMCS\Client::where('email', $custom)->first();
        }

        if (!empty($client)) {

          $exists = Custom::where('request', $request)
            ->where('reference', $plugin)
            ->first();

            $id = false;
            $user = false;
            if (class_exists('WHMCS\\Authentication\\CurrentUser')) {
              $user = new CurrentUser();
              if ($user->isAuthenticatedUser()) {
                  $id = $user->client()->id;
                  $user = $user->user()->id;
              }
            } else {
              if (isset($_COOKIE['WHMCSUID']) || isset($_SESSION['uid'])) {
                $user = (isset($_COOKIE['WHMCSUID']) ? $_COOKIE['WHMCSUID'] : $_SESSION['uid']);
                if (!empty($user) && is_numeric($user)) {
                  $client = Plugins\WHMCS\Client::find($user);
                  if (!empty($client)) {
                    $user = $client->email;
                    $id = $client->firstname . ' ' . $client->lastname;
                  }
                }
              }
            }

          if (!empty($exists)) {

            // Update Custom Integration
            $exists->custom = $user;
            $exists->data = $id;
            $exists->save();

          } else {

            // Custom Integration
            $integration = new Custom;
            $integration->request = $request;
            $integration->custom = $user;
            $integration->data = $id;
            $integration->reference = $plugin;
            $integration->save();

            $chatdetails = false;
            if (is_numeric($request) && (int)$request > 0 && $_SETTINGS['DATABASEVERSION'] < 11) {
              $chatdetails = Chat::where('request', $request)->first();
            } else if ($_SETTINGS['DATABASEVERSION'] > 10) {
              $chatvisitor = ChatVisitor::where('visitor', $request)->first();
              if (!empty($chatvisitor)) {
                $chat = $chatvisitor->chat->first();
              }
            }

            if (!empty($chatdetails) && !empty($chatdetails->username)) {

              $messagedetails = Message::where('chat', $chat)
                ->where('status', -4)
                ->first();

              if (!empty($messagedetails)) {
                // Integration Message Alert
                $message = new Message;
                $message->chat = $chat;
                $message->username = $chatdetails->username;
                $message->datetime = date('Y-m-d H:i:s', time());
                $message->message = sprintf('%s has just signed into %s', $chatdetails->username, $plugin);
                $message->align = $id;
                $message->status = -2;
                $message->save();
              }
            }
          }
        }
      }
    }

  }

  function VisitorAdded($args) {

    $visitor = $args;

    $id = false;
    $user = false;
    if (class_exists('WHMCS\\Authentication\\CurrentUser')) {
      $user = new CurrentUser();
      if ($user->isAuthenticatedUser()) {
          $id = $user->client()->id;
          $user = $user->user()->id;
      }
    } else {
      if (isset($_COOKIE['WHMCSUID']) || isset($_SESSION['uid'])) {
        $user = (isset($_COOKIE['WHMCSUID']) ? $_COOKIE['WHMCSUID'] : $_SESSION['uid']);
        if (!empty($user) && is_numeric($user)) {
          $client = Plugins\WHMCS\Client::find($user);
          if (!empty($client)) {
            $user = $client->email;
            $id = $client->firstname . ' ' . $client->lastname;
          }
        }
      }
    }

    // WHMCS Integration / Quick Links
    if (!empty($visitor) && !empty($id) && is_numeric($id) && !empty($user) && is_numeric($user)) {
      $custom = new Custom;
      $custom->request = (int)$visitor->id;
      $custom->custom = $user;
      $custom->data = $id;
      $custom->reference = 'WHMCS';
      $custom->save();
    }
  }

  function VisitorUpdated($args) {

    $visitor = $args;

    $id = false;
    $user = false;
    if (class_exists('WHMCS\\Authentication\\CurrentUser')) {
      $user = new CurrentUser();
      if ($user->isAuthenticatedUser()) {
          $id = $user->client()->id;
          $user = $user->user()->id;
      }
    } else {
      if (isset($_COOKIE['WHMCSUID']) || isset($_SESSION['uid'])) {
        $user = (isset($_COOKIE['WHMCSUID']) ? $_COOKIE['WHMCSUID'] : $_SESSION['uid']);
        if (!empty($user) && is_numeric($user)) {
          $client = Plugins\WHMCS\Client::find($user);
          if (!empty($client)) {
            $user = $client->email;
            $id = $client->firstname . ' ' . $client->lastname;
          }
        }
      }
    }

    // WHMCS Integration / Quick Links
    if (!empty($visitor) && !empty($id) && is_numeric($id) && !empty($user) && is_numeric($user)) {
      $custom = Custom::where('request', (int)$visitor->id)->first();
      if (!empty($custom)) {
        if ($custom->custom !== $user || $custom->data !== $id) {
          $custom->custom = $user;
          $custom->data = $id;
          $custom->save();
        }
      } else {
        $custom = new Custom;
        $custom->request = (int)$visitor->id;
        $custom->custom = $user;
        $custom->data = $id;
        $custom->reference = 'WHMCS';
        $custom->save();
      }
    }
  }

}

// Add Hook Functions
// $hooks->add('ExampleHooks', 'EventName', 'FunctionName');
$class = 'LiveHelpWHMCSHooks';

if (isset($_PLUGINS) && isset($_PLUGINS['WHMCS'])) {
  $hooks->add($class, 'CloseChat', 'CloseChat');
  $hooks->add($class, 'LoginCustomHash', 'LoginCustomHash');
  $hooks->add($class, 'LoginCompleted', 'LoginCompleted');
  $hooks->add($class, 'LoginFailed', 'LoginFailed');
  $hooks->add($class, 'LoginAccountMissing', 'LoginAccountMissing');
  $hooks->add($class, 'SettingsLoaded', 'SettingsLoaded');
  $hooks->add($class, 'SettingsPlugin', 'SettingsPlugin');
  $hooks->add($class, 'ResponsesCustom', 'ResponsesCustom');
  $hooks->add($class, 'DepartmentsLoaded', 'DepartmentsLoaded');
  $hooks->add($class, 'VisitorCustomDetails', 'VisitorCustomDetails');
  $hooks->add($class, 'VisitorCustomDetailsInitialised', 'VisitorCustomDetailsInitialised');
  $hooks->add($class, 'VisitorAdded', 'VisitorAdded');
  $hooks->add($class, 'VisitorUpdated', 'VisitorUpdated');
}

?>