(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["cloudsockets"],{

/***/ 157:
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var Cloudsockets,
  __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

Cloudsockets = (function() {
  var Connection, EM;

  Cloudsockets.prototype.jsonp_callbacks = [];

  function Cloudsockets(key) {
    var event_beforeunload;
    this.key = key;
    this.channels = {};
    this.events = {
      error: "error",
      success: "success",
      failure: "failure",
      connect: "connect",
      reconnect: "reconnect",
      subscribe: "subscribe",
      resubscribe: "resubscribe",
      unsubscribe: "unsubscribe",
      member: "member",
      added: "added",
      removed: "removed",
      message: "message",
      closed: "closed",
      socket: "socket",
      open: "open",
      close: "close",
      ping: "ping",
      pong: "pong",
      error: "error",
      message: "message",
      state: "state",
      history: "history"
    };
    this.states = {
      initializing: "initializing",
      connecting: "connecting",
      established: "established",
      disconnected: "disconnected",
      closed: "closed",
      error: "error"
    };
    this.configs = {
      channels_auth: {},
      auth: {
        transport: "json",
        url: "/cloudsockets/auth",
        headers: {},
        params: {}
      },
      transport: "websocket",
      debug: false,
      secure_auto: true,
      secure: null,
      ws_port: 80,
      wss_port: 443,
      host: "ws.chatstack.com",
      hosts: [],
      shared: true,
      resubscribe_channels: true,
      timeout: {
        ping: 60 * 1000,
        connect: 10 * 1000,
        pong: 70 * 1000,
        ls: 1000,
        reconnect: {
          ws: 10 * 1000,
          ls: 1500,
          none: 0
        }
      }
    };
    if (typeof window !== "undefined" && window !== null) {
      if (window.attachEvent) {
        event_beforeunload = "onbeforeunload";
      } else if (window.addEventListener) {
        event_beforeunload = "beforeunload";
      }
      this.bindDomEvent(event_beforeunload, (function(_this) {
        return function(e) {
          _this.close();
          return void 0;
        };
      })(this));
    }
    this.id = this.random();
    this.connection = new this.Connection(this);
    this.ws = new this.WS(this);
    this.ls = new this.LS(this);
    this.em = new this.EM;
    this.on = this.em.on;
    this.once = this.em.once;
    this.unbind = this.em.unbind;
    this.unbindAll = this.em.unbindAll;
    this.emit = this.em.emit;
  }

  Cloudsockets.prototype.resubscribe = function() {
    var cid;
    for (cid in this.channels) {
      this.channels[cid].subscribe();
    }
    return this;
  };

  Cloudsockets.prototype.configure = function(config) {
    this._merge(this.configs, config);
    return this;
  };

  Cloudsockets.prototype.api = function(action, params, cb) {
    var a, mid;
    mid = Date.now().toString() + Math.random().toString();
    a = action.split("/");
    this.connection.send({
      mid: mid,
      internal: "socketApi",
      data: {
        controller: a[0],
        action: a[1],
        params: params
      }
    });
    this.connection.on("socketApiResponse", (function(_this) {
      return function(msg) {
        if (msg && msg.mid === mid) {
          return cb(msg.error, msg.data);
        }
      };
    })(this));
    return this;
  };

  Cloudsockets.prototype._merge = function(obj1, obj2) {
    var e, p;
    for (p in obj2) {
      try {
        if (obj2[p].constructor === Object) {
          obj1[p] = this._merge(obj1[p], obj2[p]);
        } else {
          obj1[p] = obj2[p];
        }
      } catch (_error) {
        e = _error;
        obj1[p] = obj2[p];
      }
    }
    return obj1;
  };

  Cloudsockets.prototype.bindDomEvent = function(event, fn) {
    if (window.addEventListener) {
      window.addEventListener(event, fn, false);
    } else if (window.attachEvent) {
      window.attachEvent(event, fn);
    }
    return this;
  };

  Cloudsockets.prototype.random = function() {
    var r;
    r = this.now().toString() + Math.random().toString();
    r = r.toString().replace(".", "");
    return r;
  };

  Cloudsockets.prototype.now = function() {
    return new Date().getTime();
  };

  Cloudsockets.prototype.event = function(event, state) {
    var e;
    if (this.events[event]) {
      e = this.events[event];
      if (state) {
        if (this.events[state]) {
          e += ":" + this.events[state];
        } else {
          throw 'cloudsockets not have "' + state + '" state';
        }
      }
      return e;
    } else {
      throw 'cloudsockets not have "' + event + '" event';
    }
  };

  Cloudsockets.prototype.log = function() {
    var a, arg, _i, _len;
    if (this.configs.debug && console && console.log) {
      a = ["Cloudsockets: "];
      for (_i = 0, _len = arguments.length; _i < _len; _i++) {
        arg = arguments[_i];
        a.push(arg);
      }
      if (console.log.apply) {
        console.log.apply(console, a);
      } else {
        console.log(a.join(" "));
      }
    }
    return this;
  };

  Cloudsockets.prototype.connect = function() {
    this.disconnected = false;
    if (this.connection.state === "initializing" || this.connection.state === "disconnected" || this.connection.state === "closed") {
      this.connection.connect();
    }
    return this;
  };

  Cloudsockets.prototype.reconnect = function() {
    this.connection.forceReconnect();
    return this;
  };

  Cloudsockets.prototype.disconnect = function() {
    this.close();
    return this;
  };

  Cloudsockets.prototype.close = function(flag) {
    this.disconnected = true;
    if (flag) {
      this.channels = {};
    }
    this.connection.close();
    return this;
  };

  Cloudsockets.prototype.subscribe = function(id, request) {
    if (!this.channels[id]) {
      this.channels[id] = new this.Channel(this, id, request);
    }
    this.channels[id].subscribe();
    return this.channels[id];
  };

  Cloudsockets.prototype.unsubscribe = function(id) {
    if (this.channels[id]) {
      this.channels[id].unsubscribe();
    } else {
      this.log("channel not exist:", id);
    }
    return this;
  };

  Cloudsockets.prototype.history = function(channel_id, options) {
    if (this.channels[channel_id] && this.channels[channel_id].subscribed) {
      this.channels[channel_id].getHistory(options || {});
    } else {
      this.log("error: not subscribed to " + channel_id + " channel");
    }
    return this;
  };

  Cloudsockets.prototype.EM = EM = (function() {
    function EM() {
      this.emit = __bind(this.emit, this);
      this.unbindAll = __bind(this.unbindAll, this);
      this.unbind = __bind(this.unbind, this);
      this.once = __bind(this.once, this);
      this.on = __bind(this.on, this);
      this.stack = {};
      this.once_stack = {};
    }

    EM.prototype.on = function(event, cb) {
      var e, _i, _len;
      if (typeof event === "object" && event.length && event.length > 0) {
        for (_i = 0, _len = event.length; _i < _len; _i++) {
          e = event[_i];
          this.on(e, cb);
        }
      } else {
        if (!this.stack[event]) {
          this.stack[event] = [];
        }
        this.stack[event].push(cb);
      }
      return this;
    };

    EM.prototype.once = function(event, priority, cb) {
      if (!this.once_stack[event]) {
        this.once_stack[event] = [];
      }
      if (typeof priority === 'function') {
        cb = priority;
        priority = false;
      }
      if (priority && this.once_stack[event].length > 0) {
        this.once_stack[event].unshift(cb);
      } else {
        this.once_stack[event].push(cb);
      }
      return this;
    };

    EM.prototype.unbind = function(event) {
      if (this.stack[event]) {
        this.stack[event] = [];
      }
      if (this.once_stack[event]) {
        this.once_stack[event] = [];
      }
      return this;
    };

    EM.prototype.unbindAll = function() {
      this.stack = {};
      this.once_stack = {};
      return this;
    };

    EM.prototype.emit = function(event, data, isInternal) {
      var cb, _i, _j, _len, _len1, _ref, _ref1;
      if (this.stack[event]) {
        _ref = this.stack[event];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          cb = _ref[_i];
          if (typeof cb === "function") {
            cb(data, isInternal);
          }
        }
      }
      if (this.once_stack[event]) {
        _ref1 = this.once_stack[event];
        for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
          cb = _ref1[_j];
          if (typeof cb === "function") {
            cb(data, isInternal);
          }
        }
        this.once_stack[event] = [];
      }
      return this;
    };

    return EM;

  })();

  Cloudsockets.prototype.Connection = Connection = (function() {
    function Connection(cs) {
      this.cs = cs;
      this.em = new this.cs.EM;
      this.on = this.em.on;
      this.once = this.em.once;
      this.unbind = this.em.unbind;
      this.unbindAll = this.em.unbindAll;
      this.emit = this.em.emit;
      this.configs = this.cs.configs;
      this._connected = false;
      this.socket_open = false;
      this.not_supported = false;
      this.not_auth = false;
      this.mode = "none";
      this.state = "initializing";
      this.state_history = [this.state];
      this.on(this.cs.event("state"), (function(_this) {
        return function(state) {
          var cid;
          if (_this.state === "established") {
            _this.socket_open = true;
          } else {
            _this.socket_open = false;
            if (_this.ping_timeout) {
              clearTimeout(_this.ping_timeout);
            }
            if (_this.pong_timeout) {
              clearTimeout(_this.pong_timeout);
            }
            for (cid in _this.cs.channels) {
              _this.cs.channels[cid].resetStates();
            }
          }
        };
      })(this));
      this.on(this.cs.event("socket", "open"), (function(_this) {
        return function(msg) {
          _this.socket_open = true;
          _this.send({
            internal: "connect",
            data: {
              main: _this.mode === 'ws'
            }
          });
          if (_this.mode === 'ws') {
            _this.cs.ls.socketOpened("*");
          }
        };
      })(this));
      this.on(this.cs.event("connect", "success"), (function(_this) {
        return function(msg) {
          return _this._onConnect(msg);
        };
      })(this));
      this.on(this.cs.event("reconnect", "success"), (function(_this) {
        return function(msg) {
          return _this._onConnect(msg);
        };
      })(this));
      this.on(this.cs.event("connect", "failure"), (function(_this) {
        return function(msg) {
          return _this.update("error", msg.data);
        };
      })(this));
      this.on(this.cs.event("ping"), (function(_this) {
        return function(msg) {
          return _this.send({
            internal: _this.cs.event('pong')
          });
        };
      })(this));
      this.on(this.cs.event("pong"), (function(_this) {
        return function(msg) {};
      })(this));
      this.on(this.cs.event("message"), (function(_this) {
        return function(_arg) {
          var channel, data, raw;
          data = _arg.data, raw = _arg.raw;
          _this.cs.log("recd: ", raw);
          _this.resetPongTimeout();
          if (data.internal) {
            if (data.channel) {
              if (_this.cs.channels[data.channel]) {
                channel = _this.cs.channels[data.channel];
                if (channel._subscribed && data.internal === _this.cs.event("subscribe", "success")) {
                  data.internal = _this.cs.event("resubscribe", "success");
                }
                return channel.emit(data.internal, data, true);
              } else {
                return _this.cs.log("got message for not subscribed channel: " + data.channel + "," + (data.event || ''));
              }
            } else {
              if (_this._connected && data.internal === _this.cs.event("connect", "success")) {
                data.internal = _this.cs.event("reconnect", "success");
              }
              return _this.emit(data.internal, data);
            }
          } else {
            _this.cs.log("message not have any event");
          }
        };
      })(this));
      this.on(this.cs.event("error"), (function(_this) {
        return function(err) {
          if (_this.lastState === "established") {
            _this.update("closed", err);
          }
          if (err === 'auth fail') {
            _this.not_auth = true;
          }
          if (_this.state !== "reconnecting" && !_this.not_supported && !_this.not_auth && !_this.cs.disconnected) {
            return _this.reconnect(_this.cs.configs.timeout.reconnect[_this.mode]);
          }
        };
      })(this));
    }

    Connection.prototype._onConnect = function(msg) {
      var cid;
      this._connected = true;
      this.update("established", this.mode);
      if (this.reconnect_timeout) {
        clearTimeout(this.reconnect_timeout);
      }
      if (this.connect_timeout) {
        clearTimeout(this.connect_timeout);
      }
      this.resetPingTimeout();
      this.resetPongTimeout();
      if (this.cs.configs.resubscribe_channels) {
        for (cid in this.cs.channels) {
          this.cs.channels[cid].resetStates();
          this.cs.channels[cid].subscribe();
        }
      }
      return this;
    };

    Connection.prototype.resetPingTimeout = function() {
      if (this.ping_timeout) {
        clearTimeout(this.ping_timeout);
      }
      if (this.state === "established") {
        this.ping_timeout = setTimeout((function(_this) {
          return function() {
            return _this.send({
              internal: _this.cs.event('ping')
            });
          };
        })(this), this.configs.timeout.ping);
      }
      return this;
    };

    Connection.prototype.resetPongTimeout = function() {
      if (this.pong_timeout) {
        clearTimeout(this.pong_timeout);
      }
      if (this.state === "established") {
        this.pong_timeout = setTimeout((function(_this) {
          return function() {
            if (_this.state === "established") {
              return _this.update("error", "no messages from server");
            }
          };
        })(this), this.configs.timeout.pong);
      }
      return this;
    };

    Connection.prototype.send = function(msg) {
      var err;
      try {
        if (this.socket_open) {
          if (this.id) {
            msg.id = this.id;
            msg = JSON.stringify(msg);
            this.cs.log("sent: ", msg);
            this.resetPingTimeout();
            if (this.mode === 'ws') {
              this.cs.ws.send(msg);
            } else if (this.mode === 'ls') {
              this.cs.ls.send(msg);
            }
          } else {
            this.cs.log("send fail, no connection id");
          }
        } else {
          this.cs.log("send fail, socket not open");
          false;
        }
      } catch (_error) {
        err = _error;
        this.cs.log("send", err);
      }
      return this;
    };

    Connection.prototype.connect = function() {
      var err;
      try {
        this.id = this.cs.random().toString();
        this.cs.configs.channels_auth = {};
        this.update("connecting", this.mode);
        this.connect_timeout = setTimeout((function(_this) {
          return function() {
            if (_this.state === 'connecting') {
              return _this.update("error", "connect timeout");
            }
          };
        })(this), this.configs.timeout.connect);
        this.cs.ls.connect((function(_this) {
          return function(err) {
            if (err) {
              _this.cs.log("localStorage:", err);
            }
            if (!err) {
              return _this.mode = "ls";
            } else if (_this.cs.ws.available()) {
              _this.mode = "ws";
              return _this.cs.ws.connect();
            } else {
              return _this.notSupported();
            }
          };
        })(this));
      } catch (_error) {
        err = _error;
        this.cs.log("connection err:", err);
      }
      return this;
    };

    Connection.prototype.reconnect = function(timeout) {
      if (this.state !== "reconnecting" && !this.not_supported && !this.not_auth && !this.cs.disconnected) {
        this.update("reconnecting", this.mode);
        if (this.mode === "ws") {
          try {
            this.cs.ws.close();
          } catch (_error) {}
        }
        if (this.ping_timeout) {
          clearTimeout(this.ping_timeout);
        }
        if (this.pong_timeout) {
          clearTimeout(this.pong_timeout);
        }
        if (this.reconnect_timeout) {
          clearTimeout(this.reconnect_timeout);
        }
        if (this.connect_timeout) {
          clearTimeout(this.connect_timeout);
        }
        this.reconnect_timeout = setTimeout((function(_this) {
          return function() {
            return _this.connect();
          };
        })(this), timeout);
      }
      return this;
    };

    Connection.prototype.forceReconnect = function() {
      if (this.state === "reconnecting" && this.reconnect_timeout) {
        clearTimeout(this.reconnect_timeout);
        this.connect();
      }
      return this;
    };

    Connection.prototype.close = function() {
      if (this.ping_timeout) {
        clearTimeout(this.ping_timeout);
      }
      if (this.pong_timeout) {
        clearTimeout(this.pong_timeout);
      }
      if (this.connect_timeout) {
        clearTimeout(this.connect_timeout);
      }
      if (this.reconnect_timeout) {
        clearTimeout(this.reconnect_timeout);
      }
      this.update("closed", this.mode);
      if (this.mode === "ws") {
        this.cs.ls.destroyServer();
        this.cs.ws.close();
      } else if (this.mode === "ls") {
        this.cs.ls.close();
      }
      this.mode = "none";
      delete this.id;
      return this;
    };

    Connection.prototype.notSupported = function() {
      this.not_supported = true;
      if (this.connect_timeout) {
        clearTimeout(this.connect_timeout);
      }
      this.update("error", "websockets not supported");
      return this;
    };

    Connection.prototype.update = function(state, data) {
      if (data) {
        this.cs.log(state + " " + data);
      } else {
        this.cs.log(state);
      }
      this.state_history.push(state);
      this.lastState = this.state;
      this.state = state;
      this.emit("state", state);
      if (data) {
        this.emit(state, data);
      }
      return this;
    };

    return Connection;

  })();

  Cloudsockets.prototype.WS = (function() {
    function _Class(cs) {
      this.cs = cs;
      this.onclose = __bind(this.onclose, this);
      this.onerror = __bind(this.onerror, this);
      this.onmessage = __bind(this.onmessage, this);
      this.onopen = __bind(this.onopen, this);
      this.open = false;
      this.errorDate = 0;
    }

    _Class.prototype.available = function() {
      return true;
    };

    _Class.prototype.connect = function() {
      var Socket, err;
      try {
        this.configs = this.cs.configs;
        if (this.configs.secure === null) {
          this.configs.secure = true;
          this.configs.secure_auto = true;
        } else {
          this.configs.secure_auto = false;
        }
        if (typeof process !== "undefined" && process !== null) {
          if (this.configs.secure_auto) {
            this.configs.secure_auto = false;
            this.configs.secure = true;
          }
        } else {
          if (this.configs.secure_auto) {
            if (location && location.protocol && location.protocol.indexOf("https") === 0) {
              this.configs.secure = true;
            } else {
              this.configs.secure = false;
            }
          }
        }
        if (this.configs.secure) {
          this.port = this.configs.wss_port;
          if (this.cs.configs.transport === "sockjs" && (typeof process === "undefined" || process === null)) {
            this.protocol = "https://";
          } else {
            this.protocol = "wss://";
          }
        } else {
          this.port = this.configs.ws_port;
          if (this.cs.configs.transport === "sockjs" && (typeof process === "undefined" || process === null)) {
            this.protocol = "http://";
          } else {
            this.protocol = "ws://";
          }
        }
        if (this.configs.hosts && this.configs.hosts.length > 0) {
          this.configs.host = this.configs.hosts[Math.floor(Math.random() * this.configs.hosts.length)];
        } else {
          this.configs.host = this.cs.configs.host;
        }
        switch (this.cs.configs.transport) {
          case "sockjs":
            this.url = this.protocol + this.configs.host + ":" + this.port + '/socket/';
            if (typeof process !== "undefined" && process !== null) {
              this.url += 'websocket';
              Socket = __webpack_require__(!(function webpackMissingModule() { var e = new Error("Cannot find module 'ws'"); e.code = 'MODULE_NOT_FOUND'; throw e; }()));
            } else {
              Socket = SockJS;
            }
            this.socket = new Socket(this.url);
            this.socket.onopen = this.onopen;
            this.socket.onmessage = this.onmessage;
            this.socket.onerror = this.onerror;
            this.socket.onclose = this.onclose;
            break;
          case 'websocket':
            this.url = this.protocol + this.configs.host + ":" + this.port + '/socket/' + this.cs.key;
            if (typeof process !== "undefined" && process !== null) {
              Socket = __webpack_require__(!(function webpackMissingModule() { var e = new Error("Cannot find module 'ws'"); e.code = 'MODULE_NOT_FOUND'; throw e; }()));
            } else {
              Socket = window.WebSocket || window.MozWebSocket;
            }
            this.socket = new Socket(this.url);
            this.socket.onopen = this.onopen;
            this.socket.onmessage = this.onmessage;
            this.socket.onerror = this.onerror;
            this.socket.onclose = this.onclose;
        }
        this.cs.log(this.cs.configs.transport + " connecting to " + (this.url || this.configs.host));
      } catch (_error) {
        err = _error;
        this.cs.log("err: ", err);
        this.cs.connection.notSupported();
      }
      return this;
    };

    _Class.prototype.send = function(msg, force) {
      var err;
      if (this.open) {
        if (typeof msg === 'object') {
          msg = JSON.stringify(msg);
        }
        if (this.cs.connection.socket_open || force) {
          try {
            this.socket.send(msg);
          } catch (_error) {
            err = _error;
            this.cs.log("websocket err: " + err.toString());
          }
        }
      }
      return this;
    };

    _Class.prototype.onopen = function(e) {
      var msg;
      this.open = true;
      if (this.cs.configs.transport === "sockjs" || this.cs.configs.transport === "xmpp") {
        msg = JSON.stringify({
          internal: "auth",
          data: this.cs.key
        });
        this.cs.log("sent: ", msg);
        this.send(msg, true);
      }
      this.cs.ls.ws_onopen(e);
      return this;
    };

    _Class.prototype.onmessage = function(message, flags) {
      var data, raw;
      raw = message.data || message.getChild && message.getChild('body').getText() || "{}";
      data = JSON.parse(raw);
      if (data.internal) {
        if (data.id && data.id !== this.cs.connection.id) {
          this.cs.ls.ws_onmessage(data, raw);
        } else {
          this.cs.connection.emit("message", {
            data: data,
            raw: raw
          });
        }
      } else {
        this.cs.log("invalid message");
      }
      return this;
    };

    _Class.prototype.onerror = function(e) {
      this.open = false;
      this.errorDate = new Date().getTime();
      delete this.cs.connection.id;
      this.cs.connection.update("error", e.toString());
      this.cs.ls.ws_onerror(e);
      return this;
    };

    _Class.prototype.onclose = function(e) {
      this.open = false;
      delete this.cs.connection.id;
      if (this.cs.connection.state !== "closed" && this.cs.connection.state !== "error" && (new Date().getTime() - this.errorDate > 100)) {
        this.cs.connection.update("error", "ws connection closed");
        this.cs.ls.ws_onerror("socket closed");
      }
      return this;
    };

    _Class.prototype.close = function() {
      if (this.open) {
        try {
          this.socket.close();
        } catch (_error) {}
      }
      return this;
    };

    return _Class;

  })();

  Cloudsockets.prototype.LS = (function() {
    function _Class(cs) {
      this.cs = cs;
      this.onStorage = __bind(this.onStorage, this);
      this.close = __bind(this.close, this);
      this.em = new this.cs.EM;
      this.on = this.em.on;
      this.once = this.em.once;
      this.unbind = this.em.unbind;
      this.unbindAll = this.em.unbindAll;
      this.emit = this.em.emit;
      this.m = "Cloudsockets: ";
      this.server = false;
      this.client = false;
      this.connections = {};
      this.apps = {};
      if (typeof window !== "undefined" && window !== null) {
        if (window.localStorage) {
          this.db = window.localStorage;
        }
        if (this.db && (window.addEventListener || window.attachEvent)) {
          this.available = true;
        }
      }
      if (this.available) {
        this.cs.bindDomEvent('storage', this.onStorage);
      }
    }

    _Class.prototype.connect = function(cb) {
      var err;
      if (!this.available) {
        err = "ls not available";
      }
      if (!this.cs.configs.shared) {
        this.available = false;
        err = "ls not available by configs";
      }
      if (err) {
        this.cs.log(err);
        cb(err);
      } else {
        this.socket = null;
        this.connect_callback = cb;
        this.set("getSocket", "*", this.cs.connection.id);
        setTimeout((function(_this) {
          return function() {
            if (_this.connect_callback) {
              if (typeof _this.connect_callback === "function") {
                _this.connect_callback("ls provider not found");
              }
              return delete _this.connect_callback;
            }
          };
        })(this), 100);
      }
      return this;
    };

    _Class.prototype.close = function(e) {
      if (this.cs.connection.mode === "ls") {
        this.set("close", this.socket);
        this.destroyClient();
      }
      return this;
    };

    _Class.prototype.initServer = function(apps, connections) {
      this.server = true;
      this.connections = connections || {};
      this.apps = apps || {};
      this.client = false;
      this.serverTimeouts = {};
      this.clearTimeouts();
      return this;
    };

    _Class.prototype.destroyServer = function() {
      var newServer;
      if (this.server) {
        newServer = this.selectNewServer();
        this.set("newServer", "*", {
          server: newServer,
          apps: this.apps,
          connections: this.connections
        });
      }
      return this;
    };

    _Class.prototype.initClient = function(provider, data) {
      data = data || {};
      this.server = false;
      this.connections = data.connections || {};
      this.apps = data.apps || {};
      this.client = true;
      this.socket = provider;
      this.resetTimeout();
      return this;
    };

    _Class.prototype.destroyClient = function() {
      this.server = false;
      this.connections = {};
      this.apps = {};
      this.client = false;
      this.clearTimeouts();
      return this;
    };

    _Class.prototype.selectNewServer = function(lastServer) {
      var cs_id, newServer;
      newServer = this.cs.id;
      for (cs_id in this.apps) {
        newServer = cs_id;
        break;
      }
      if (this.apps[newServer]) {
        delete this.connections[this.apps[newServer]];
        delete this.apps[newServer];
      }
      return newServer;
    };

    _Class.prototype.clearTimeouts = function() {
      var client_id, timeout;
      if (this.ping_timeout) {
        clearTimeout(this.ping_timeout);
      }
      if (this.pong_timeout) {
        clearTimeout(this.pong_timeout);
      }
      for (client_id in this.serverTimeouts) {
        timeout = this.serverTimeouts[client_id];
        if (timeout) {
          clearTimeout(timeout);
        }
      }
      return this;
    };

    _Class.prototype.resetTimeout = function() {
      this.clearTimeouts();
      this.ping_timeout = setTimeout((function(_this) {
        return function() {
          if (_this.cs.connection.mode === "ls") {
            _this.pong_timeout = setTimeout(function() {
              var newServer;
              if (_this.cs.connection.mode === "ls") {
                newServer = _this.selectNewServer();
                if (newServer === _this.cs.id) {
                  _this.cs.connection.mode = "none";
                }
                _this.destroyClient();
                return _this.cs.connection.update("error", "socket provider not responding");
              }
            }, _this.cs.configs.timeout.ls);
            return _this.set("ping", _this.socket);
          }
        };
      })(this), this.cs.configs.timeout.ls);
      return this;
    };

    _Class.prototype.resetServerTimeout = function(client_id) {
      if (this.serverTimeouts[client_id]) {
        clearTimeout(this.serverTimeouts[client_id]);
      }
      this.serverTimeouts[client_id] = setTimeout((function(_this) {
        return function() {
          if (_this.apps && _this.apps[client_id]) {
            if (_this.cs.connection.socket_open) {
              _this.cs.ws.send({
                id: _this.apps[client_id],
                internal: _this.cs.event("close")
              });
            }
            delete _this.connections[_this.apps[client_id]];
            return delete _this.apps[client_id];
          }
        };
      })(this), this.cs.configs.timeout.ls * 3);
      return this;
    };

    _Class.prototype.socketOpened = function(target) {
      this.set("socketOpened", target);
      return this;
    };

    _Class.prototype.onStorage = function(e) {
      var cs_key, event, key, origin, prefix, target, val, _name;
      if (!e) {
        e = window.event;
      }
      if (e.key && e.newValue) {
        key = e.key.split(":");
        prefix = key[0];
        cs_key = key[1];
        event = key[2];
        origin = key[3];
        target = key[4];
        val = e.newValue;
        if (key.length === 5 && prefix === "cs" && cs_key === this.cs.key && (target === this.cs.id || target === "*")) {
          if (typeof this[_name = "on_" + event] === "function") {
            this[_name](origin, val, target, event);
          }
        }
      }
      return this;
    };

    _Class.prototype.set = function(event, target, val) {
      var err, key;
      if (this.available) {
        try {
          if (typeof val === 'object') {
            try {
              val = JSON.stringify(val);
            } catch (_error) {
              err = _error;
              val = err;
            }
          }
          if (!target) {
            target = "*";
          }
          if (!val) {
            val = this.cs.now();
          }
          key = ["cs", this.cs.key, event, this.cs.id, target].join(":");
          val = val.toString();
          this.db.removeItem(key);
          try {
            this.db.setItem(key, val);
          } catch (_error) {
            err = _error;
            if (this.cs.connection.mode === "ls") {
              this.destroyClient();
              this.cs.connection.mode = "none";
              delete this.cs.connection.id;
              this.cs.connection.update("error", "localStorage set error");
            }
          }
          this.db.removeItem(key);
        } catch (_error) {}
      }
      return this;
    };

    _Class.prototype.send = function(msg) {
      if (this.socket && this.cs.connection.mode === "ls") {
        this.set("sendMessage", this.socket, msg);
      }
      return this;
    };

    _Class.prototype.ws_onopen = function(e) {
      return this;
    };

    _Class.prototype.ws_onmessage = function(msg, raw) {
      if (this.connections && this.connections[msg.id] && this.cs.connection.mode === "ws") {
        this.set("receiveMessage", this.connections[msg.id], msg);
      }
      return this;
    };

    _Class.prototype.ws_onerror = function(e) {
      if (this.cs.connection.mode === "ws") {
        this.set("error", "*", e);
      }
      return this;
    };

    _Class.prototype.on_ping = function(origin) {
      if (this.cs.connection.mode === 'ws' && this.server && this.apps && this.apps[origin]) {
        this.resetServerTimeout(origin);
        this.set("pong", origin, {
          apps: this.apps,
          connections: this.connections
        });
      }
      return this;
    };

    _Class.prototype.on_pong = function(origin, data) {
      if (this.cs.connection.mode === 'ls' && origin === this.socket && this.client) {
        data = JSON.parse(data);
        this.apps = data.apps;
        this.connections = data.connections;
        this.resetTimeout();
      }
      return this;
    };

    _Class.prototype.on_getSocket = function(origin, connection_id) {
      if (this.cs.connection.mode === 'ws' && this.cs.configs.shared && !this.cs.connection.not_auth) {
        this.cs.log("providing socket to " + origin);
        if (!this.server) {
          this.initServer();
        }
        this.connections[connection_id] = origin;
        this.apps[origin] = connection_id;
        this.set("setSocket", origin, {
          connections: this.connections,
          apps: this.apps
        });
        this.resetServerTimeout(origin);
        if (this.cs.connection.socket_open) {
          setTimeout((function(_this) {
            return function() {
              if (_this.cs.connection.socket_open) {
                return _this.socketOpened(origin);
              }
            };
          })(this), 100);
        }
      }
      return this;
    };

    _Class.prototype.on_setSocket = function(origin, data) {
      if (this.connect_callback) {
        this.cs.log("ls connection available");
        this.initClient(origin, JSON.parse(data));
        if (typeof this.connect_callback === "function") {
          this.connect_callback(null);
        }
        delete this.connect_callback;
      }
      return this;
    };

    _Class.prototype.on_socketOpened = function(origin) {
      if (origin === this.socket && this.cs.connection.state !== "established" && this.cs.connection.state !== "closed") {
        this.cs.connection.emit(this.cs.event("socket", "open"), this.cs.connection.mode);
      }
      return this;
    };

    _Class.prototype.on_newServer = function(origin, data) {
      if (this.cs.connection.mode === 'ls') {
        data = JSON.parse(data);
        if (data.server === this.cs.id) {
          this.destroyClient();
          this.initServer(data.apps, data.connections);
          this.cs.connection.mode = "none";
        }
        this.cs.connection.update("error", "socket provider closed");
      }
      return this;
    };

    _Class.prototype.on_sendMessage = function(origin, data) {
      if (this.cs.connection.mode === 'ws' && this.server && this.apps[origin]) {
        this.cs.ws.send(data);
      }
      return this;
    };

    _Class.prototype.on_receiveMessage = function(origin, val) {
      var data, raw;
      if (this.cs.connection.mode === 'ls' && this.client && this.socket === origin) {
        raw = val;
        try {
          data = JSON.parse(raw);
        } catch (_error) {}
        this.cs.connection.emit("message", {
          data: data,
          raw: raw
        });
      }
      return this;
    };

    _Class.prototype.on_error = function(origin, data) {
      if (this.cs.connection.mode === "ls" && this.client && this.socket === origin) {
        try {
          data = JSON.parse(data);
        } catch (_error) {}
        this.cs.connection.update("error", data);
      }
      return this;
    };

    _Class.prototype.on_close = function(origin) {
      var connection_id;
      if (this.cs.connection.mode === 'ws' && this.server && this.apps[origin]) {
        connection_id = this.apps[origin];
        this.cs.log("client " + origin + " disconnected");
        delete this.apps[origin];
        delete this.connections[connection_id];
        if (this.serverTimeouts[origin]) {
          clearTimeout(this.serverTimeouts[origin]);
        }
        if (this.cs.connection.socket_open) {
          this.cs.ws.send({
            id: connection_id,
            internal: this.cs.event("close")
          });
        }
      }
      return this;
    };

    return _Class;

  })();

  Cloudsockets.prototype.Channel = (function() {
    function _Class(cs, id, request) {
      this.cs = cs;
      this.id = id;
      this.request = request;
      if (this.id.indexOf("presence-") === 0) {
        this.type = "presence";
      } else if (this.id.indexOf("private-") === 0) {
        this.type = "private";
      } else {
        this.type = "public";
      }
      this.em = new this.cs.EM;
      this.on = this.em.on;
      this.once = this.em.once;
      this.unbind = this.em.unbind;
      this.unbindAll = this.em.unbindAll;
      this.emit = this.em.emit;
      this.m = "Cloudsockets: ";
      this.members = {
        count: 0,
        members: {}
      };
      this.subscribeCount = 0;
      this._subscribed = false;
      this.resetStates();
      this.history = [];
      this.on(this.cs.event('history'), (function(_this) {
        return function(msg) {
          if (msg.data && msg.data.messages) {
            _this.history = msg.data;
          }
        };
      })(this));
      this.on(this.cs.event('message'), (function(_this) {
        return function(msg, isInternal) {
          if (msg.event && isInternal && msg.event !== "message") {
            _this.cs.channels[msg.channel].emit(msg.event, msg, false);
          }
        };
      })(this));
      this.on(this.cs.event("member", "added"), (function(_this) {
        return function(msg) {
          var info;
          info = msg.data;
          _this.members.members[info.id] = info;
          _this.members.count++;
          _this.emit('member_added', info, true);
        };
      })(this));
      this.on(this.cs.event("member", "removed"), (function(_this) {
        return function(msg) {
          var info;
          info = msg.data;
          delete _this.members.members[info.id];
          _this.members.count--;
          _this.emit('member_removed', info, true);
        };
      })(this));
      this.on(this.cs.event("subscribe", "failure"), (function(_this) {
        return function() {
          _this.subscribing = false;
          if (_this.cs.configs.channels_auth && _this.cs.configs.channels_auth[_this.id]) {
            _this.cs.configs.channels_auth[_this.id] = false;
            _this.subscribe();
          }
        };
      })(this));
      this.on(this.cs.event("subscribe", "success"), (function(_this) {
        return function(msg) {
          _this._onSubscribe(msg);
        };
      })(this));
      this.on(this.cs.event("resubscribe", "success"), (function(_this) {
        return function(msg) {
          _this._onSubscribe(msg);
        };
      })(this));
      this.on(this.cs.event('unsubscribe', 'success'), (function(_this) {
        return function() {
          _this.unsubscribing = false;
          _this.subscribed = false;
          delete _this.cs.channels[_this.id];
        };
      })(this));
      this.on(this.cs.event('unsubscribe', 'failure'), (function(_this) {
        return function() {
          _this.unsubscribing = false;
        };
      })(this));
    }

    _Class.prototype.resetStates = function() {
      this.subscribing = false;
      this.subscribed = false;
      this.unsubscribing = false;
      return this;
    };

    _Class.prototype._onSubscribe = function(msg) {
      this._subscribed = true;
      this.subscribing = false;
      this.subscribed = true;
      if (msg.data) {
        if (msg.data.presence) {
          this.members.count = msg.data.presence.count;
          this.members.members = msg.data.presence.hash;
        }
      }
      return this;
    };

    _Class.prototype.toJSON = function() {
      var result;
      result = {};
      result.id = this.id;
      result.presence = {
        count: this.members.count,
        hash: this.members.hash
      };
      return result;
    };

    _Class.prototype.getMembers = function(format) {
      var res;
      res = "";
      switch (format) {
        case "json":
          try {
            res = JSON.stringify(this.members);
          } catch (_error) {}
          break;
        default:
          res = this.members;
      }
      return res;
    };

    _Class.prototype.send = function(event, data) {
      this.cs.connection.send({
        internal: 'message',
        event: event,
        channel: this.id,
        data: data
      });
      return this;
    };

    _Class.prototype.getHistory = function(options) {
      if (this.subscribed) {
        options = options || {};
        options.limit = options.limit || options.count;
        if (options.count != null) {
          delete options.count;
        }
        this.cs.connection.send({
          internal: this.cs.event("history"),
          channel: this.id,
          data: options
        });
      } else {
        this.emit(this.cs.event("history"), {
          error: "cannot get history: not subscribed to " + this.id + " channel",
          data: []
        });
      }
      return this;
    };

    _Class.prototype.subscribe = function() {
      if (!this.subscribing && !this.subscribed) {
        this.subscribing = true;
        this.subscribeCount++;
        this.auth((function(_this) {
          return function(err, data) {
            if (err) {
              return _this.cs.log(err);
            } else {
              return _this.cs.connection.send({
                internal: _this.cs.event("subscribe"),
                data: data
              });
            }
          };
        })(this));
      } else {
        if (this.subscribing) {
          this.cs.log("already subscribing to " + this.id);
        } else if (this.subscribed) {
          this.cs.log("already subscribed to " + this.id);
        }
      }
      return this;
    };

    _Class.prototype.unsubscribe = function() {
      if (!this.unsubscribing && this.subscribed) {
        this.unsubscribing = true;
        this.cs.connection.send({
          internal: this.cs.event("unsubscribe"),
          data: {
            channel: this.id
          }
        });
      } else {
        if (this.unsubscribing) {
          this.cs.log("already unsubscribing from " + this.id);
        } else if (!this.subscribed) {
          this.cs.log("not subscribed to " + this.id);
        }
      }
      return this;
    };

    _Class.prototype.auth = function(cb) {
      if (this.type !== 'public') {
        if (this.cs.configs.channels_auth && this.cs.configs.channels_auth[this.id]) {
          cb(null, this.cs.configs.channels_auth[this.id]);
        } else {
          if (this.cs.configs.auth.transport === "request" && this.request) {
            this.node_request(cb);
          } else if (this.cs.configs.auth.transport === "json") {
            this.json(cb);
          } else if (this.cs.configs.auth.transport === "jsonp") {
            this.jsonp(cb);
          } else if (this.cs.configs.auth.transport === "socket") {
            this.socket(cb);
          }
        }
      } else {
        cb(null, {
          channel_id: this.id
        });
      }
      return this;
    };

    _Class.prototype.node_request = function(cb) {
      var req;
      req = {
        url: this.cs.configs.auth.url,
        method: "POST",
        headers: {
          "Content-Type": "application/json"
        },
        body: JSON.stringify(this.getReq())
      };
      this.request(req, (function(_this) {
        return function(err, res, body) {
          try {
            body = JSON.parse(body);
          } catch (_error) {
            err = _error;
            _this.cs.log(err);
          }
          return typeof cb === "function" ? cb(err, body) : void 0;
        };
      })(this));
      return this;
    };

    _Class.prototype.json = function(cb) {
      var headerName, xhr;
      xhr = (window.XMLHttpRequest ? new window.XMLHttpRequest() : new ActiveXObject("Microsoft.XMLHTTP"));
      xhr.open("POST", this.cs.configs.auth.url, true);
      xhr.setRequestHeader("Content-Type", "application/json");
      for (headerName in this.cs.configs.auth.headers) {
        xhr.setRequestHeader(headerName, this.cs.configs.auth.headers[headerName]);
      }
      xhr.onreadystatechange = (function(_this) {
        return function() {
          var data, e, err;
          if (xhr.readyState === 4) {
            err = "err";
            data = {};
            if (xhr.status === 200) {
              try {
                err = null;
                data = JSON.parse(xhr.responseText);
              } catch (_error) {
                e = _error;
                err = "invalid json";
              }
            } else {
              err = xhr.status;
            }
            return cb(err, data);
          }
        };
      })(this);
      xhr.send(JSON.stringify(this.getReq()));
      return this;
    };

    _Class.prototype.jsonp = function(cb) {
      var head, i, id, req, script;
      id = this.cs.jsonp_callbacks.length;
      this.cs.jsonp_callbacks.push((function(_this) {
        return function(data) {
          return cb(null, data);
        };
      })(this));
      req = '&connection_id=' + encodeURIComponent(this.cs.connection.id);
      req += '&channel_id=' + encodeURIComponent(this.id);
      for (i in this.cs.configs.auth.params) {
        req += "&" + encodeURIComponent(i) + "=" + encodeURIComponent(this.cs.configs.auth.params[i]);
      }
      req = this.cs.configs.auth.url + "?callback=Cloudsockets.prototype.jsonp_callbacks[" + id + "]" + req;
      script = document.createElement("script");
      script.src = req;
      if (document) {
        head = document.getElementsByTagName("head")[0] || document.documentElement;
        head.insertBefore(script, head.firstChild);
      }
      return this;
    };

    _Class.prototype.socket = function(cb) {
      this.cs.api("auth/channel", this.getReq(), cb);
      return this;
    };

    _Class.prototype.getReq = function() {
      var i, req;
      req = {
        connection_id: this.cs.connection.id,
        channel_id: this.id
      };
      for (i in this.cs.configs.auth.params) {
        req[i] = this.cs.configs.auth.params[i];
      }
      return req;
    };

    return _Class;

  })();

  return Cloudsockets;

})();

if (( true && module !== null) && module.exports) {
  module.exports = Cloudsockets;
}

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(158)(module)))

/***/ }),

/***/ 158:
/***/ (function(module, exports) {

module.exports = function(module) {
	if (!module.webpackPolyfill) {
		module.deprecate = function() {};
		module.paths = [];
		// module.parent = undefined by default
		if (!module.children) module.children = [];
		Object.defineProperty(module, "loaded", {
			enumerable: true,
			get: function() {
				return module.l;
			}
		});
		Object.defineProperty(module, "id", {
			enumerable: true,
			get: function() {
				return module.i;
			}
		});
		module.webpackPolyfill = 1;
	}
	return module;
};


/***/ })

}]);