(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["initiate"],{

/***/ 131:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.initInitiateChat = exports.updateInitiateStatus = exports.openInitiateChatTab = exports.openInitiateChat = exports.hideInitiateChat = void 0;

__webpack_require__(96);

// Core
var core = __webpack_require__(64);

function toggleInitiateInputs(hide, overrideMessage) {
  if (core.app.length) {
    if (core.opts.chatstate.waiting && !core.app.is('.connected')) {
      core.app.add(core.container).addClass('connecting');
    } // Override Content


    var content = core.opts.introduction;

    if (overrideMessage) {
      content = overrideMessage;
    }

    var initiate = core.app.find('.scroll .initiate.chat');

    if (!core.opts.popup && content && initiate.length && !initiate.find('.message .content').length) {
      var message = initiate.find('.message');

      if (core.opts.messageBubbles) {
        message.addClass('bubble left');
      }

      __webpack_require__.e(/* import() | messages */ "messages").then(__webpack_require__.t.bind(null, 132, 7)).then(function (messages) {
        messages.replaceMessageContent(content).then(function (content) {
          var html = '<div class="content">' + content + '</div>';
          message.html(html);
          initiate.addClass('active'); // TODO Fix Message Initiate Scroll
          //initiate.show();
        });
      });
    }

    if (core.settings.embeddedinitiate && core.settings.embeddedinitiate.id > 0 && !core.opts.accepted) {
      core.showOperatorDetails(core.settings.embeddedinitiate, !hide);
    }
  }
}

function updateInitiateChatState(state, message, image) {
  var oldState = Chatstack.initiateChatState;

  switch (state) {
    case 0:
      state = 'idle';
      break;

    case -1:
      state = 'waiting';
      break;

    case -2:
      state = 'accepted';
      break;

    case -3:
      state = 'declined';
      break;
  }

  Chatstack.initiateChatState = state;

  if (oldState !== state) {
    var data = {
      state: state
    };

    if (message) {
      data.message = message;
    }

    if (image) {
      data.image = image;
    }

    Chatstack.events.trigger('InitiateChatStateChanged', data);
  }
}

function updateInitiateChatImage(initiate, feedback, image) {
  // Gravatar
  var url = 'url(\'' + image + '\')';
  var avatar = '.initiate.chat .avatar';
  $('<img />').one('error', function () {
    $(this).remove();
    url = 'url(\'' + core.opts.server + core.apiPath + core.apiEndpoint.image + '?size=150&round=true\')';
    var photo = initiate.find('.operator.photo');

    if (!photo.is('.alert')) {
      photo.css('background-image', url);
    }

    if (core.opts.chatstate.idle || core.opts.chatstate.waiting || core.opts.chatstate.completed) {
      core.app.find(avatar).css('background-image', url);
    }

    if (!feedback && core.settings.initiate && core.settings.initiate.enabled && (!core.settings.initiate.delay || core.opts.initiateElapsed)) {
      openInitiateChat(initiate);
    }
  }).one('load', function () {
    $(this).remove();
    var photo = initiate.find('.operator.photo');

    if (!photo.is('.alert')) {
      photo.css('background-image', url);
    }

    if (core.opts.chatstate.idle || core.opts.chatstate.waiting || core.opts.chatstate.completed) {
      core.app.find(avatar).css('background-image', url);
    }

    if (!feedback) {
      openInitiateChat(initiate);
    }
  }).attr('src', image);
}

var closeInitiateChat = function closeInitiateChat(closing) {
  return function (e) {
    var offline = core.initiatechat.is('.offline');
    var message = core.initiatechat.is('.message');

    if (closing) {
      if (e) {
        e.stopPropagation();
      }

      if (!offline && !message) {
        updateInitiateStatus(-3); // Declined
      }
    }

    if (offline && closing) {
      core.toggleOfflineChat();
      return;
    } else if (core.app.is('.feedback') || closing) {
      core.closeFeedback();
      return;
    }

    if (offline) {
      return;
    }

    hideInitiateChat(core.initiatechat);

    if (core.opts.embedded) {
      openInitiateChatTab();
      core.initiatechat.removeClass('opened');
      core.container.removeClass('initiate-opened');
    } else {
      openLiveHelp();
      updateInitiateStatus(-1); // Opened
    }
  };
};

function showInitiateChat(initiate) {
  if (!initiate.is('.opened')) {
    core.chatbutton.add(core.chatbuttonframe).addClass('initiate');
    initiate.addClass('opened').removeClass('hidden');
    core.container.addClass('initiate-opened'); // Sound

    if (core.messageSound && core.storage.data.soundEnabled) {
      core.playInitiateChatSound();
    }
  }
}

var hideInitiateChat = function hideInitiateChat(initiate) {
  if (initiate.is('.opened')) {
    core.chatbutton.add(core.chatbuttonframe).removeClass('initiate');
    initiate.removeClass('opened').addClass('hidden');
    core.container.removeClass('initiate-opened');
  }
};

exports.hideInitiateChat = hideInitiateChat;

var openInitiateChat = function openInitiateChat(initiate) {
  var core = __webpack_require__(64); // Initiate Chat Events


  initiate.find('.bubble, .feedback').on('click', function (e) {
    if (core.app.is('.feedback')) {
      e.preventDefault();
      return false;
    }
  });
  initiate.find('a').on('click', function (e) {
    e.stopPropagation();
  }); // Setup Initiate Chat

  initiate.on('click', closeInitiateChat(false));
  initiate.find('.close').on('click', closeInitiateChat(true));
  initiate.find('.feedback textarea').on('keypress', function (event) {
    if (event.which === 13) {
      sendFeedback();
      return false;
    } else {
      return true;
    }
  });
  initiate.find('.brand').on('click', function (e) {
    e.stopPropagation();
  });

  if (core.app.is('.opened')) {
    return;
  } // Message Alert


  var message = initiate.is('.message');

  if (message) {
    showInitiateChat(initiate);
  }

  var bubble = core.initiatechat.find('.bubble'),
      bubbleBottom = 10,
      bottom = -(bubble.height() + parseInt(bubble.css('margin-top'), 10) + parseInt(bubble.css('margin-bottom'), 10) + parseInt(core.initiatechat.css('padding-top'), 10) + parseInt(core.initiatechat.css('padding-bottom'), 10) + bubbleBottom),
      height = core.initiatechat.find('.bubble').outerHeight() - 60,
      frameheight = height + 95,
      collapsed = initiate.attr('data-collapsed') === 'true';

  if (!core.storage.data.feedbackOpen && core.settings.status !== 'Online' && !message) {
    bubbleBottom = '-' + (parseInt(initiate.find('.bubble').outerHeight(), 10) + parseInt(initiate.find('.bubble').css('margin-top'), 10)) + 'px';
    height = initiate.css('height') + 'px';
    collapsed = true;

    if (!initiate.is('.offline')) {
      initiate.find('.close').hide();
    } else {
      bubbleBottom = 0;
    }
  }

  if (initiate.is('.offline')) {
    height = 'auto';
    frameheight = false;
  } // TODO Open Initiate Chat Animation
  //initiate.find('.bubble').animate({ 'bottom': bubbleBottom }, 250, 'swing');


  initiate.find('.bubble').css({
    'bottom': bubbleBottom,
    'height': 'auto'
  });

  if (frameheight) {
    core.chatbuttonframe.css('height', frameheight + 'px');
  }

  initiate.attr('data-collapsed', collapsed);

  if (height !== 'auto') {
    height = height + 70 + 'px'; // TODO Open Initiate Chat Animation
    //initiate.animate({ 'height': height }, 250, 'swing');

    initiate.css({
      'height': height
    });
  } else {
    initiate.css({
      'height': height
    });
  }

  if (core.opts.chatstate.connected) {
    if (message) {
      bottom = 0;
      showInitiateChat(initiate);
    } else {
      hideInitiateChat(initiate);
    }

    initiate.css('bottom', bottom);
  } else if (!core.storage.data.offlineOpen) {
    hideInitiateChat(initiate);
  }

  if (!initiate.is('.offline') && (core.opts.chatstate.idle || core.opts.chatstate.completed || message) && !core.opts.disabled) {
    core.chatbutton.add(core.container).removeClass('enabled').addClass('disabled');
    showInitiateChat(initiate);
  }
};

exports.openInitiateChat = openInitiateChat;

var openInitiateChatTab = function openInitiateChatTab() {
  var textarea = core.app.find('.message.textarea');
  toggleInitiateInputs();
  var css = 'closed';

  if (core.opts.disabled) {
    css += ' hidden';
  }

  if (!core.opts.popup) {
    core.app.add(core.container).removeClass('opened').addClass(css);
  }

  core.storage.data.operatorDetailsOpen = true;
  core.updateStorage();
  core.chatbuttonframe.css('height', '');
  core.openTab(true).then(function () {
    window.setTimeout(function () {
      textarea.focus();
    }, 500);
  });
  updateInitiateStatus(-1);
  core.app.addClass('initiate').attr('data-initiate', true);
  core.app.attr('data-opened', true);
};

exports.openInitiateChatTab = openInitiateChatTab;

var updateInitiateStatus = function updateInitiateStatus(status, message, image) {
  // Update Initiate Chat Status
  if (core.settings.initiate && core.settings.initiate.status !== status) {
    core.settings.initiate.status = status;
    core.settings.initiate.update = true;

    if (core.visitorInitialised > 0) {
      core.visitorTimeout = false;
      status = status || 0;

      if (status === -2 || status === -3) {
        core.$parent(core.selector + 'InitiateChat').hide(); //.fadeOut();
      } // Javascript API


      updateInitiateChatState(status, message, image); // Update Settings

      core.updateSettingsTimed(true);
    }
  }
};

exports.updateInitiateStatus = updateInitiateStatus;

var initInitiateChat = function initInitiateChat(hide, offline, overrideMessage, overrideImage) {
  toggleInitiateInputs(hide, overrideMessage);
  var content = core.opts.introduction,
      initiate = core.initiatechat,
      collapsed = initiate.length && initiate.attr('data-collapsed') === 'true' ? true : false,
      image = false;

  if (!initiate.length) {
    var operator = core.settings.embeddedinitiate;

    if (operator.id > 0) {
      image = 'https://secure.gravatar.com/avatar/' + operator.avatar + '?s=150&r=g&d=404';
    }

    if (core.settings.images.initiatechat && core.settings.images.initiatechat.length) {
      image = core.settings.images.initiatechat;
    } // Override image


    if (overrideImage) {
      image = overrideImage;
    } // Override Content


    if (overrideMessage) {
      content = overrideMessage;
    } // Offline


    if (core.app.is('.offline')) {
      content = core.settings.language.offlinemessagedescription;
    } // Feedback


    if ($.isArray(core.opts.feedback) && core.opts.feedback.length && core.settings.status !== 'Online') {
      core.opts.feedback.sort(function () {
        return Math.round(Math.random()) - 0.5;
      });
      content = core.opts.feedback[0];
    }

    var rating = [{
      css: 'good',
      title: core.settings.language.good,
      rating: 3
    }, {
      css: 'poor',
      title: core.settings.language.poor,
      rating: 1
    }];
    rating.sort(function () {
      return Math.round(Math.random()) - 0.5;
    });
    var _offline = '';

    if (core.app.is('.offline')) {
      _offline = 'offline';
    }
    /*jshint multistr: true */


    var html = '<div class="' + core.namespace + '-initiate-chat ' + _offline + '" data-collapsed="false"> \
<div class="message bubble right"> \
<div class="tab"> \
<div class="title">' + core.settings.language.offlinemessagetitle + '</div> \
<div class="text content">' + content + '</div> \
</div> \
<div class="intro">' + core.settings.language.feedbackintroduction + '</div> \
<div class="text content">' + content + '</div> \
<div class="feedback"> \
<input class="email input" type="text" tabindex="100" placeholder="' + core.settings.language.enteryourfeedbackemail + '"/> \
<textarea class="message input" type="text" tabindex="200" placeholder="' + core.settings.language.enteryourfeedback + '"></textarea> \
<div class="needsupport hidden">' + core.settings.language.needsupport + '  <a href="#" target="_blank">' + core.settings.language.clickhere + '</a></div> \
<div class="rating container"> \
  <div class="rating ' + rating[0].css + '" title="' + rating[0].title + '" data-rating="' + rating[0].rating + '"></div> \
  <div class="rating neutral" title="' + core.settings.language.neutral + '" data-rating="2"></div> \
  <div class="rating ' + rating[1].css + '" title="' + rating[1].title + '" data-rating="' + rating[1].rating + '"></div> \
</div> \
</div> \
<div class="offline"> \
<form id="OfflineMessageForm" method="post" class="form"> \
  <div> \
    <input class="name input" type="text" autocomplete="name" tabindex="100" placeholder="' + core.settings.language.enteryourofflinename + '"/> \
    <div class="name error sprite TickSmall" title="Name Required" class=""></div> \
  </div> \
  <div> \
    <input class="email input" type="text" autocomplete="email" tabindex="200" placeholder="' + core.settings.language.enteryourofflineemail + '"/> \
    <div class="email error sprite TickSmall" title="Email Required"></div> \
  </div> \
  <input class="website input" type="text" autocomplete="none" tabindex="400"/> \
  <div> \
    <textarea class="message input" type="text" tabindex="300" placeholder="' + core.settings.language.enteryourofflinemessage + '"></textarea> \
    <div class="message error sprite TickSmall" title="Message Required"></div> \
  </div> \
  <div class="securitycode"> \
    <label class="label">' + core.settings.language.securitycode + '</label> \
    <div class="content"> \
      <input class="security input" data-index="1" type="text" autocomplete="email" maxlength="1" tabindex="300"/> \
      <input class="security input" data-index="2" type="text" autocomplete="email" maxlength="1" tabindex="305"/> \
      <input class="security input" data-index="3" type="text" autocomplete="email" maxlength="1" tabindex="310"/> \
      <input class="security input" data-index="4" type="text" autocomplete="email" maxlength="1" tabindex="315"/> \
      <div class="code"></div> \
      <div class="loading-inner ball-clip-rotate"> \
        <div></div> \
      </div> \
      <div class="refresh button"> \
        <div class="refresh icon light"></div> \
      </div> \
    </div> \
    <div class="security error sprite TickSmall" title="Email Required"></div> \
  </div> \
</form> \
<div class="sending"> \
  <div class="loading-inner ball-clip-rotate"> \
    <div></div> \
  </div> \
  <div class="text">Sending</div> \
</div> \
</div> \
<a href="https://www.chatstack.com" target="_blank" class="brand"><div class="icon"></div></a> \
</div> \
<div class="operator photo"></div> \
<div class="operator badge">1</div> \
<div class="close" title="' + core.settings.language.close + '"><span class="icon">&#10005;</span><span class="text">' + core.settings.language.close + '</span></div> \
</div>';
    var parent = core.chatbutton.closest('#' + core.namespace + '-container');
    core.initiatechat = $(html).appendTo(parent);

    if (core.settings.rtl) {
      core.initiatechat.addClass('rtl');
    } // Copyright


    var brand = core.initiatechat.find('.brand');
    __webpack_require__.e(/* import() | brand */ "brand").then(__webpack_require__.t.bind(null, 135, 7)).then(function (copyrighticon) {
      brand.find('.icon').html(copyrighticon.default);
    });

    if (core.settings.language.copyright.length) {
      brand.add(initiate).addClass('copyright');
    } // Security Code


    if (core.settings.captcha && core.settings.captcha.code) {
      // Enable Security Code
      core.initiatechat.add(core.chatbuttonframe).addClass('security'); // Update Image

      var code = core.initiatechat.find('.securitycode .code');
      var captcha = code.find('svg');

      if (!captcha.length && core.settings.captcha && core.settings.captcha.image) {
        code.attr('data-captcha', core.settings.captcha.code).html(core.settings.captcha.image);
      } // Security Code Refresh


      core.initiatechat.find('.securitycode .refresh.button').on('click', function () {
        var security = $(this).closest('.securitycode');
        security.addClass('loading');
        core.updateSettingsTimed().then(function () {
          // Update Security Code
          security.find('.code').attr('data-captcha', core.settings.captcha.code).html(core.settings.captcha.image);
          security.removeClass('loading');
        });
      });
    } // Offline Widget Events


    core.initiatechat.find('.offline .email.input, .offline .message.input').on('change keyup input focus blur', function () {
      core.toggleOfflineSendButton();
    });
    core.initiatechat.find('.offline .security.input').on('keydown', function (e) {
      var value = $(this).val();
      var next = parseInt($(this).attr('data-index'), 10);

      if (e.keyCode == 9) {
        return;
      }

      if (value.length) {
        if (e.keyCode == 8) {
          $(this).val('');
          e.preventDefault();
        } else {
          next = next + 1;
          core.initiatechat.find('.offline .security.input[data-index="' + next + '"]').focus();
        }
      } else {
        if (e.keyCode == 8) {
          next = next - 1;
          core.initiatechat.find('.offline .security.input[data-index="' + next + '"]').val('').focus();
          e.preventDefault();
        }
      }
    }); // Security Code

    core.initiatechat.find('.offline .security.input').on('keyup', function (e) {
      var value = $(this).val();
      var next = parseInt($(this).attr('data-index'), 10);

      if (value.length) {
        if (e.keyCode !== 8 && e.keyCode !== 9) {
          next = next + 1;
        }
      }

      core.initiatechat.find('.offline .security.input[data-index="' + next + '"]').focus();
    });
    var feedback = false;

    if (core.app.is('.feedback')) {
      core.initiatechat.addClass('feedback rating');
      feedback = true;

      if (core.settings.images.feedback && core.settings.images.feedback.length) {
        image = core.settings.images.feedback;
      }

      var supportaddress = false;

      if (core.settings.supportaddress.length && (core.settings.supportaddress.indexOf('https://') !== -1 || core.settings.supportaddress.indexOf('http://') !== -1)) {
        var support = core.initiatechat.find('.needsupport');
        supportaddress = true;
        support.find('a').attr('href', core.settings.supportaddress);
        support.removeClass('hidden');
      }

      rating = core.$parent('.rating.container');
      rating.find('.rating').on('click', function () {
        var element = $(this),
            type = 'neutral',
            text = 'How can we improve?',
            score = parseInt($(this).attr('data-rating'), 10);

        switch (score) {
          case 1:
            type = 'poor';
            text = 'Sorry to hear that.  Please let us know how we can improve.';
            break;

          case 3:
            type = 'good';
            text = 'That\'s great!  Please let us know if you have any feedback.';
            break;
        }

        element.parent().find('.rating[data-rating!=" + score + "]').addClass('deselected');
        element.removeClass('deselected');
        core.initiatechat.removeClass('rating').addClass(type);
        var height = '223px';

        if (supportaddress) {
          height = '241px';
        }

        core.initiatechat.css('height', height);
        element = core.initiatechat.find('.text.content');
        core.initiatechat.attr('data-question', element.text());
        core.initiatechat.find('.text.content').text(text);
      });
    } else {
      core.initiatechat.removeClass('feedback'); // Javascript API

      if (hide || !_offline) {
        updateInitiateStatus(-1, content, image); // Opened
      }
    }

    $(core.documents.js).trigger(core.prefix + '.InitiateChatLoaded'); // Initiate Chat Image

    updateInitiateChatImage(core.initiatechat, feedback, image);

    if (hide && !core.opts.popup) {
      core.app.add(core.container).removeClass('opened').addClass('closed hidden');
    }
  } else {
    // Override Content
    if (overrideMessage) {
      content = overrideMessage;
    }

    var element = initiate.find('.text.content');

    if (initiate.length && !initiate.is('.sent') && !initiate.is('.feedback') && !core.app.is('.offline') && element.text() !== content) {
      element.text(content);
    } // Override image


    if (overrideImage) {
      image = overrideImage;
      updateInitiateChatImage(initiate, false, overrideImage);
    }

    if (core.opts.embedded && !core.chatbutton.is(':visible') && collapsed) {
      showInitiateChat(initiate);
    } // Javascript API


    if (hide) {
      updateInitiateStatus(-1, content, image); // Opened
    }
  }
};

exports.initInitiateChat = initInitiateChat;

function sendFeedback() {
  var initiate = core.initiatechat,
      email = initiate.find('input'),
      input = initiate.find('textarea'),
      text = initiate.find('.text.content'),
      question = initiate.attr('data-question'),
      score = parseInt(core.$parent('.rating.container .rating.option:not(.deselected)').attr('data-rating'), 10),
      data = {
    QUESTION: question,
    EMAIL: email.val(),
    MESSAGE: input.val(),
    SCORE: score,
    SESSION: core.cookies.session,
    JSON: true
  };
  $.ajax({
    url: core.opts.server + core.apiPath + core.apiEndpoint.feedback,
    data: $.param(data),
    success: function success(data) {
      // Process JSON Errors / Result
      if (data.result && data.result === true) {
        text.text('Thanks for the feedback!');
        initiate.find('.feedback input, .feedback textarea').hide();
        var height = initiate.find('.bubble').outerHeight() + 25 + 'px'; // TODO Send Feedback Animation
        //initiate.animate({ 'height': height }, 250, 'swing');

        initiate.css({
          'height': height
        });
        core.storage.store.set('feedback', true);
      }
    },
    dataType: 'jsonp',
    cache: false,
    xhrFields: {
      withCredentials: true
    }
  });
}

var _default = function _default(overrideDelay, overrideStatus, overrideMessage, overrideImage) {
  var setupInitiateChat = function setupInitiateChat(overrideStatus, overrideMessage, overrideImage) {
    if (core.opts.initiate && (core.settings.status !== undefined && core.settings.status === 'Online' || overrideStatus !== undefined)) {
      if (core.settings.embeddedinitiate !== undefined && core.settings.embeddedinitiate != null) {
        // Embedded Initiate Chat
        if ((core.app.is('.closed') || core.app.is('.hidden')) && core.opts.visitorTracking && !$.data(core.app, 'initiate') && core.settings.initiate.status !== -3) {
          initInitiateChat(true, false, overrideMessage, overrideImage);
        }
      }
    }
  };

  if (core.opts.initiateDelay > 0 && !overrideDelay) {
    window.setTimeout(function () {
      setupInitiateChat(overrideStatus, overrideMessage, overrideImage);
      core.opts.initiateElapsed = true;
    }, core.opts.initiateDelay);
  } else {
    setupInitiateChat(overrideStatus, overrideMessage, overrideImage);
  }
};

exports.default = _default;
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(61)))

/***/ })

}]);