(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["messages"],{

/***/ 132:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {

var _interopRequireDefault = __webpack_require__(1);

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.disconnectChat = disconnectChat;
exports.sendMessage = sendMessage;
exports.updateTyping = updateTyping;
exports.updateOperatorDetails = updateOperatorDetails;
exports.showChat = showChat;
exports.startChat = startChat;
exports.default = exports.promptEmail = exports.replaceMessageContent = void 0;

__webpack_require__(65);

__webpack_require__(2);

__webpack_require__(83);

__webpack_require__(133);

__webpack_require__(47);

__webpack_require__(81);

__webpack_require__(96);

__webpack_require__(12);

var _once = _interopRequireDefault(__webpack_require__(50));

var _debounce = _interopRequireDefault(__webpack_require__(54));

var _assign = _interopRequireDefault(__webpack_require__(107));

var _sha = _interopRequireDefault(__webpack_require__(128));

// Lodash
// Crypto
// Core
var core = __webpack_require__(64);

var message = 0;
var consecutive = false;
var currentlyTyping = 0;

function display(message) {
  return new Promise(function (resolve) {
    var output = '',
        messages = core.app.find('.messages'),
        content = false,
        exists = false,
        datetime = message.timestamp || message.datetime;
    var name = message.username;

    if (message.firstname && message.firstname.length) {
      name = message.firstname;
    }

    if (!isNaN(parseInt(message.id, 10)) && core.app.find('.flex[data-id=' + message.id + ']').length) {
      exists = true;
    } else {
      $(core.documents.js).trigger(core.prefix + '.message.contentRead', {
        message: message.id
      });
    }

    if (messages && message.content !== null && !core.storage.data.chatEnded && !exists) {
      var alignment = 'left',
          color = 'received',
          rtl = '';

      if (message.id === -1 && core.opts.initiate) {
        __webpack_require__.e(/* import() | initiate */ "initiate").then(__webpack_require__.t.bind(null, 131, 7)).then(function (initiate) {
          initiate.initInitiateChat(false, message.content);
        });
        return false;
      } else if (message.id === -2) {
        if (core.storage.data.operatorDetailsOpen !== undefined && core.storage.data.operatorDetailsOpen) {
          core.showOperatorDetails(core.opts.operator);
        }

        if (core.queued && core.queued.length && core.settings.loginDetails !== 0) {
          sendMessage(core.queued[0]);
          core.queued = [];
        }

        return false;
      }

      if (message.align === 2) {
        alignment = 'center';
      } else if (message.align === 3) {
        alignment = 'right';
      }

      if (message.status === 0) {
        color = 'sent';
      }

      if (!core.storage.data.chatEnded && !core.opts.chatBubbles && core.settings.layout === 'tab') {
        core.app.find('.details.collapse.button'); //.fadeIn();
      }

      if (core.settings.rtl === true) {
        rtl = '; direction: rtl; text-align: right';
        alignment = 'right';
      }

      if (datetime === undefined) {
        datetime = message.id;
      }

      var style = 'message ' + color,
          flex = 'flex',
          margin = 15,
          avatar = '',
          avatarstyle = '';

      if (message.id < -1) {
        flex += ' left none';
      }

      if (core.opts.messageBubbles && message.id >= -1) {
        style = 'message bubble ' + color + ' ';
        margin = 0;

        if (message.status === 1 || message.status === 2 || message.status === 3 || message.status === 7 || message.status === 8) {
          style += 'left';
          flex += ' left';
        } else {
          style += 'right';
          flex += ' right';
        }

        if (message.from && !consecutive || message.alert) {
          var url = false;
          var key = (0, _sha.default)(message.from.toString()).toString();

          if (core.images[key]) {
            url = core.images[key];
          } else if (message.status === 1 && message.from) {
            var image = message.image || false;
            url = core.operatorImageURL(message.from, 120, message.avatar, image);
            core.images[key] = url;
          }

          if (url) {
            avatar = 'background-image: url(' + url + ')';
          }

          avatarstyle = ' ' + key;
        } else {
          style += ' noarrow';
        }
      }

      var operatorname = '';

      if (message.id >= -1 && message.status > 0 && message.status !== 5) {
        if (!consecutive || message.alert) {
          flex += ' grouped';

          if (message.alert) {
            name = message.alert;
          }

          operatorname = '<div class="name">' + name + '</div>';
        }

        consecutive = true;
      } else {
        consecutive = false;
      }

      var hash = '';

      if (message.status === 8) {
        style += ' joined';
        hash = message.hash;
      }

      if (core.opts.chatstate.connected) {
        core.showMessageInput();
      }

      output += '<div class="' + flex + '" data-id="' + message.id + '" data-datetime="' + datetime + '" data-name="' + name + '"><div class="avatar' + avatarstyle + '" style="' + avatar + '"></div>' + operatorname + '<div class="' + style + '" data-hash="' + hash + '" style="' + rtl + '">';

      if (message.status === 0 || message.status === 1 || message.status === 2 || message.status === 7 || message.status === 8) {
        // Operator, Link, Mobile Device Messages, Operator Joined
        if (core.app.find('.messages .message.joined[data-hash="' + hash + '"]').length) {
          return '';
        }

        if (name && typeof name === 'string' && name.length) {
          if (!core.opts.messageBubbles) {
            output += name + ' ' + core.settings.language.says + ':<br/>';
          }

          if (message.status > 0) {
            core.operator = name;
          }
        } // Check RTL Language


        var dir = '';

        if (core.settings.rtl === true) {
          dir = '; direction: rtl';
        }

        __webpack_require__(132).replaceMessageContent(message.content).then(function (content) {
          var regEx = /^.*((youtu.be\/)|(v\/)|(embed\/)|(watch\?))\??v?=?([^#&?]*).*/i,
              match = regEx.exec(content),
              width = messages.width();

          if (match !== null && match.length > 6) {
            var videoid = match[6];
            alignment = 'left';

            if (message.status === 2) {
              var size = {
                width: 260,
                height: 195
              },
                  css = 'message-video fancybox.iframe',
                  path = 'embed/',
                  target = 'self';

              if (core.opts.popup) {
                size = {
                  width: 480,
                  height: 360
                };
                css = 'message-video-popup';
                path = 'watch?v=';
                target = 'blank';
              }

              content = '<a href="http://www.youtube.com/' + path + videoid + '" target="_' + target + '" class="' + css + '"><div style="position:relative; height:' + size.height + 'px; margin:5px"><div class="noresize" style="position:absolute; opacity:0.5; top:0px; z-index:150; background:url(' + core.opts.server + core.directoryPath + 'images/Play.png) center center no-repeat; max-width:' + size.width + 'px; width:' + size.width + 'px; height:' + size.height + 'px"></div><div style="position:absolute; top:0px;"><img src="http://img.youtube.com/vi/' + videoid + '/0.jpg" alt="YouTube Video" class="noresize" style="width:' + size.width + 'px; max-width:' + width + 'px"></div></div></a>';
            } else {
              content = content.replace(/((?:(?:http(?:s?))|(?:ftp)):\/\/[^\s|<|>|'|"]*)/g, '<a href="$1" target="_blank" class="message-link fancybox.iframe">$1</a>');
              content = htmlSmilies(content);
              content = '<div style="text-align: ' + alignment + '; margin-left: ' + margin + 'px' + dir + '">' + content + '</div>';
            }

            output += content;
          } else {
            output += '<div style="text-align: ' + alignment + '; margin-left: ' + margin + 'px' + dir + '">' + content + '</div>';
          }

          if (output.length) {
            output += '</div></div>';
          }

          resolve(output);
        });
      } else if (message.status === 3) {
        // Image
        content = message.content.replace(/((?:(?:http(?:s?))):\/\/[^\s|<|>|'|"]*)/g, '<img src="$1" alt="Received Image">');
        var result = content.match(/((?:(?:http(?:s?))):\/\/[^\s|<|>|'|"]*)/g);

        if (result) {
          $('<img />').on('load', displayImage(message.id)).attr('src', result);
        } else {
          output += content;
        }

        output += '</div></div>';
        resolve(output);
      } else if (message.status === 4) {
        // PUSH
        openPUSH(message.content);
        output += '<div style="margin-top:5px">' + core.settings.language.pushedurl + ', <a href="' + message.content + '" target="_blank" class="message">' + message.content + '</a> ' + core.settings.language.opennewwindow + '</div></div></div>';
        resolve(output);
      } else if (message.status === 5) {
        // JavaScript

        /*jshint -W054 */
        try {
          new Function(message.content)(message);
        } catch (e) {
          console.log('JavaScript Command Error: ' + e);
          console.log(message.content);
        }

        output = '';
        resolve(output);
      } else if (message.status === 6) {
        // File Transfer
        output += core.settings.language.sentfile + ' <a href="' + message.content + '" target="' + core.namespace + '-download">' + core.settings.language.startdownloading + '</a> ' + core.settings.language.rightclicksave + '</div></div>';
        resolve(output);
      }
    }
  });
}

function autoCollapseOperatorDetails() {
  var scroll = core.app.find('.scroll');

  if (!core.app.is('.no-op') && scroll.get(0).scrollHeight > scroll.height()) {
    core.app.find('.details.collapse.button').click();
  }
}

function outputMessages(messages) {
  // Output Messages
  var html = '',
      lastMessage = false,
      margin = [25, 25, 25, 25];
  messages.forEach(function (message) {
    display(message).then(function (content) {
      if (!core.storage.data.chatEnded && !core.opts.chatBubbles) {
        core.app.find('.collapse.button'); //.fadeIn();
      }

      core.app.find('.messages').append(content); // Scroll

      core.scrollBottom(); // First Message

      var element = core.app.find('.messages .flex.left').first();

      if (element.length && core.opts.operator.firstname) {
        var first = core.app.find('.messages .flex.left, ' + '.messages .flex.initiate').first();

        if (first.length) {
          var name = first.find('.name');
          var chatting = element.data('name');

          if (chatting.length) {
            name.text(core.settings.language.chattingwith + ' ' + chatting).show();
          }
        }
      } // Select Last


      var last = '.messages .flex.left.grouped';
      $(last + '.last').removeClass('last');
      $(last + ':last').addClass('last'); // Sort Messages

      core.app.find('.messages .flex:not(.initiate), .messages ' + core.selector + 'Continue').sort(function (a, b) {
        a = parseInt($(a).data('datetime'), 10);
        b = parseInt($(b).data('datetime'), 10);
        return a < b ? -1 : a > b ? 1 : 0;
      }).appendTo('.messages');

      if (!core.opts.popup) {
        margin = [25, 405, 25, 25];
      }

      core.app.find('.message-link, .message-video').fancybox({
        beforeShow: beforeShow,
        afterClose: afterClose,
        buttons: ['download', 'close'],
        margin: margin
      });
    });

    if (message.content.length) {
      html += message.content;
    }

    if (core.settings.offlineEmail && core.app.find(core.selector + 'Continue').length) {
      core.app.find(core.selector + 'Continue').hide();
    }

    lastMessage = message;

    if (message.status > 0) {
      core.newMessages++;
    }
  });

  if (html.length) {
    autoCollapseOperatorDetails();

    if (!window.isActive && message > 0) {
      showTitleNotification();
    }

    if (lastMessage !== false && lastMessage.id > core.storage.data.lastMessage) {
      if (!core.storage.data.chatEnded && core.app.is('.closed')) {
        if (core.newMessages > 0) {
          showNotification();
        }
      } else {
        core.newMessages = 0;

        if (core.messageSound && !core.storage.data.chatEnded && core.storage.data.soundEnabled && (core.opts.popup || core.storage.data.notificationEnabled)) {
          core.messageSound.play();
        }
      }
    }
  }

  if (lastMessage !== false) {
    if (lastMessage.id > 0) {
      message = lastMessage.id;
    } // Show Last Message Alert


    if (lastMessage.status > 0 && lastMessage.status !== 4 && lastMessage.status !== 5) {
      showMessageAlert(lastMessage);
    } // Store Last Message


    if (lastMessage.id > core.storage.data.lastMessage) {
      core.storage.data.lastMessage = lastMessage.id;
      core.updateStorage();
    }
  }
}

function showMessageAlert(message) {
  var content = message.content;

  if (content.length > 150) {
    content = content.substr(0, 150) + '...';
  }

  var initiate = core.initiatechat;

  if (initiate && !initiate.is('.opened')) {
    initiate.find('.photo').css('background-image', 'url(\'' + message.image + '\')').addClass('alert');
    initiate.find('.message.bubble .text').text(content);
    initiate.find('.close').show();
    initiate.removeClass('feedback offline').addClass('message'); // Message Alert

    core.chatbutton.addClass('message alert');

    if (!core.app.is('.opened')) {
      core.app.removeClass('feedback').addClass('hidden');
    }

    __webpack_require__.e(/* import() | initiate */ "initiate").then(__webpack_require__.t.bind(null, 131, 7)).then(function (initiate) {
      initiate.openInitiateChat(core.initiatechat);
    });
  }
}

function showTitleNotification() {
  var state = false;

  function updateTitle() {
    var newTitle = state ? core.title : core.operator + ' messaged you';
    $(core.documents.parent).attr('title', newTitle);
    state = !state;
  }

  if (!core.titleTimer) {
    core.titleTimer = window.setInterval(updateTitle, 2000);
  }
}

function showNotification() {
  if (core.storage.data.notificationEnabled) {
    if (core.newMessages > 0) {
      var text = core.newMessages > 99 ? '...' : core.newMessages;
      core.app.find('.notification span').text(text);
    }

    if (core.messageSound && core.storage.data.soundEnabled && core.storage.data.notificationEnabled) {
      core.messageSound.play();
    }
  }
}

function openPUSH(message) {
  if (core.opts.embedded) {
    var body = core.$parent('body');

    if (exists.length) {
      exists.attr('src', message);
    } else {
      $.featherlight(body, {
        namespace: 'chatstack-featherlight',
        root: core.$parent('body'),
        iframe: message,
        beforeOpen: function beforeOpen() {
          body.css('overflow', 'hidden');
        },
        beforeClose: function beforeClose() {
          body.css('overflow', 'auto');
        }
      });
    }
  } else {
    var parent = window.opener;

    if (parent) {
      parent.location.href = message;
      parent.focus();
    }
  }
}

var beforeShow = function beforeShow() {
  core.$parent('.' + core.namespace + '-js-frame').addClass(core.namespace + '-lightbox');
};

var afterClose = function afterClose() {
  core.$parent('.' + core.namespace + '-js-frame').removeClass(core.namespace + '-lightbox');
};

var displayImage = function displayImage(id) {
  return function () {
    var output = '',
        avatar = core.app.find('.flex.left .avatar'),
        bubble = core.app.find('.flex.left .message.bubble'),
        width = core.app.find('.messages').width() - avatar.width() - parseInt(avatar.css('margin-left'), 10) - parseInt(avatar.css('margin-right'), 10) - parseInt(bubble.css('margin-left'), 10) - parseInt(bubble.css('margin-right'), 10),
        displayWidth = width - 50,
        margin = [25, 25, 25, 25];

    if (this.width > displayWidth) {
      var aspect = displayWidth / this.width,
          displayHeight = this.height * aspect + 10;
      output = '<div class="' + core.prefix + 'Image" style="position:relative; max-width:' + this.width + 'px; max-height:' + this.height + 'px; height:' + displayHeight + 'px; min-width: 200px"><div style="position:absolute; top:0px;"><a href="' + this.src + '" class="fancybox"><img src="' + this.src + '" alt="Received Image" style="width:100%; max-width:' + this.width + 'px; max-height:' + this.height + 'px"></a></div><div class="image zoom"><div class="icon"></div></div>';
    } else {
      output = '<img src="' + this.src + '" alt="Received Image" style="max-width:' + this.width + 'px; margin:5px">';
    }

    core.app.find('.flex[data-id=' + id + '] .message').addClass('image').append(output);
    output = '';
    core.scrollBottom();

    if (!core.opts.popup) {
      margin = [25, 405, 25, 25];
    }

    core.app.find('.flex[data-id=' + id + '] .fancybox').fancybox({
      beforeShow: beforeShow,
      afterClose: afterClose,
      buttons: ['download', 'close'],
      margin: margin
    });
    core.app.find('.flex[data-id=' + id + '] .image.zoom').on('click', clickImage(id));

    if (core.messageSound && core.storage.data.soundEnabled && core.storage.data.notificationEnabled) {
      core.messageSound.play();
    }

    window.focus();
  };
};

var replaceMessageContent = function replaceMessageContent(content) {
  return __webpack_require__.e(/* import() | marked */ "marked").then(__webpack_require__.t.bind(null, 140, 7)).then(function (marked) {
    // Email and Links
    content = content.replace(/([a-z0-9][a-z0-9_.-]{0,}[a-z0-9]@[a-z0-9][a-z0-9_.-]{0,}[a-z0-9][.][a-z0-9]{2,4})/g, '<a href="mailto:$1" class="message-email">$1</a>');
    content = content.replace(/((?:(?:http(?:s?))|(?:ftp)):\/\/[^\s|<|>|'|"]*)/g, '<a href="$1" target="_blank">$1</a>'); // Markdown Renderer

    var renderer = new marked.Renderer();

    renderer.list = function (body) {
      return body;
    };

    renderer.listitem = function (text) {
      return text;
    }; // Markdown


    marked.setOptions({
      renderer: renderer,
      gfm: false,
      tables: false,
      smartLists: false
    });
    content = marked(content); // Smilies

    if (core.settings.smilies) {
      content = htmlSmilies(content);
    }

    return content;
  }).catch(function () {
    return content;
  });
};

exports.replaceMessageContent = replaceMessageContent;

function htmlSmilies(message) {
  function replaceSmilie(subject, smilie) {
    if (subject.match(smilie.regex)) {
      return replaceSmilie(subject.replace(smilie.regex, ' <span title="' + smilie.css + '" class="sprite ' + smilie.css + ' Small Smilie"></span> '), smilie);
    } else {
      return subject;
    }
  }

  if (core.settings.smilies) {
    var smilies = [{
      regex: /^<p>:D<\/p>$|^<p>:D | :D | :D<\/p>$/g,
      css: 'Laugh'
    }, {
      regex: /^<p>:\)<\/p>$|^<p>:\) | :\) | :\)<\/p>$/g,
      css: 'Smile'
    }, {
      regex: /^<p>:\(<\/p>$|^<p>:\( | :\( | :\(<\/p>$/g,
      css: 'Sad'
    }, {
      regex: /^<p>\$\)<\/p>$|^<p>\$\) | \$\) | \$\)<\/p>$/g,
      css: 'Money'
    }, {
      regex: /^<p>&gt;:O<\/p>$|^<p>&gt;:O |^>:O | &gt;:O | >:O | &gt;:O$| >:O<\/p>$/g,
      css: 'Angry'
    }, {
      regex: /^<p>:P<\/p>$|^<p>:P | :P | :P<\/p>$/g,
      css: 'Impish'
    }, {
      regex: /^<p>:\\<\/p>$|^<p>:\\ | :\\ | :\\<\/p>$/g,
      css: 'Sweat'
    }, {
      regex: /^<p>8\)<\/p>$|^<p>8\) | 8\) | 8\)<\/p>$/g,
      css: 'Cool'
    }, {
      regex: /^<p>&gt;:L<\/p>$|^<p>&gt;:L |^>:L | &gt;:L | >:L | &gt;:L$| >:L<\/p>$/g,
      css: 'Frown'
    }, {
      regex: /^<p>;\)<\/p>$|^<p>;\) | ;\) | ;\)<\/p>$/g,
      css: 'Wink'
    }, {
      regex: /^<p>:O<\/p>$|^<p>:O | :O | :O<\/p>$/g,
      css: 'Surprise'
    }, {
      regex: /^<p>8-\)<\/p>$|^<p>8-\) | 8-\) | 8-\)<\/p>$/g,
      css: 'Woo'
    }, {
      regex: /^<p>8-O<\/p>$|^<p>8-O | 8-O | 8-O<\/p>$/g,
      css: 'Shock'
    }, {
      regex: /^<p>xD<\/p>$|^<p>xD | xD | xD<\/p>$/g,
      css: 'Hysterical'
    }, {
      regex: /^<p>:-\*<\/p>$|^<p>:-\* | :-\* | :-\*<\/p>$/g,
      css: 'Kissed'
    }, {
      regex: /^<p>:S<\/p>$|^<p>:S | :S | :S<\/p>$/g,
      css: 'Dizzy'
    }, {
      regex: /^<p>\+O\)<\/p>$|^<p>\+O\) | \+O\) | \+O\)<\/p>$/g,
      css: 'Celebrate'
    }, {
      regex: /^<p>&lt;3<\/p>$|^<p><3$|^&lt;3|^<3 | &lt;3|<3 | &lt;3<\/p>$| <3$/g,
      css: 'Adore'
    }, {
      regex: /^<p>zzZ<\/p>$|^<p>zzZ | zzZ | zzZ<\/p>$/g,
      css: 'Sleep'
    }, {
      regex: /^<p>:X<\/p>$|^<p>:X | :X | :X<\/p>$/g,
      css: 'Stop'
    }, {
      regex: /^<p>X-\(<\/p>$|^<p>X-\( | X-\( | X-\(<\/p>$/g,
      css: 'Tired'
    }];

    for (var i = 0; i < smilies.length; i++) {
      var smilie = smilies[i];
      message = message.trim();
      message = replaceSmilie(message, smilie);
    }
  }

  return message.trim();
}

function updateTypingStatus(data) {
  var typing = data.typing && data.typing.status ? data.typing.status : false,
      obj = core.app.find('.typing');

  if (typing) {
    // Update Name
    if (data.typing && data.typing.name) {
      core.app.find('.typing span').text(data.typing.name + ' ' + core.settings.language.istyping);
    }

    obj.show();
  } else {
    obj.hide();
  }
}

var promptEmail = (0, _debounce.default)(function () {
  var core = __webpack_require__(64);

  core.showEmailPrompt(false);
}, 90000);
exports.promptEmail = promptEmail;

function disconnectChat() {
  var core = __webpack_require__(64); // Reset Idle
  //core.opts.connecting = false;
  //core.opts.connected = false;
  // Javascript API


  core.updateChatState('disconnected');
  core.storage.data.chatEnded = true;
  core.storage.data.department = '';
  core.storage.data.lastMessage = 0;
  core.updateStorage();
  core.message = 0;
  $.ajax({
    url: core.opts.server + core.apiPath + core.apiEndpoint.signout,
    data: {
      SESSION: encodeURIComponent(core.cookies.session)
    },
    cache: false,
    xhrFields: {
      withCredentials: true
    },
    success: function success() {
      if (core.opts.popup) {
        window.close();
      }

      $(core.documents.js).trigger(core.prefix + '.Disconnect');
    },
    error: function error(jqXHR, textStatus) {
      console.log(textStatus);
    }
  });
}

var initEvents = (0, _once.default)(function () {
  $(core.documents.js).on(core.prefix + '.UpdateMessages', function (event, data) {
    var messages = Promise.resolve(/* import() */).then(__webpack_require__.t.bind(null, 132, 7));

    if (data) {
      if (data.status) {
        data.status = 0;
      } else if (data.status > 0) {
        messages.promptEmail();
      }
    }

    core.opts.accepted = true;
    messages.default();
  });
  $(core.documents.js).on(core.prefix + '.MessageReceived', function (event, data) {
    // Default Alignment and Status
    if (data.align === undefined) {
      data.align = 1;
    }

    if (data.status === undefined) {
      data.status = 0;
    }

    var messages = Promise.resolve(/* import() */).then(__webpack_require__.t.bind(null, 132, 7));

    if (data.status > 0) {
      messages.promptEmail();
    }

    messages.outputMessages([data]);
  }); // Toolbar

  core.app.find('.toolbar .icon').hover(function () {
    $(this).addClass('hover');
  }, function () {
    $(this).removeClass('hover');
  }); // Message Textarea

  core.app.find('.message.textarea').focus(function () {
    $(this).parent().addClass('focussed');
  }).blur(function () {
    $(this).parent().removeClass('focussed');
  }); // Sound Button

  core.app.find('.toolbar .sound').on('click', function () {
    if (core.storage.data.soundEnabled) {
      core.storage.data.soundEnabled = false;
    } else {
      core.storage.data.soundEnabled = true;
    }

    core.updateStorage();
    core.toggleSound();
  }); // Disconnect Button

  core.app.find('.toolbar .disconnect').on('click', function () {
    var core = __webpack_require__(64);

    core.app.find('.disconnect.dialog').addClass('active');
  }); // Feedback Button

  core.app.on('click', '.toolbar .rating', function () {
    $(this).toggleClass('selected');

    var core = __webpack_require__(64);

    core.showRating();
  }); // Disconnect Dialog

  var disconnect = core.app.find('.disconnect.dialog');
  disconnect.find('.button.cancel').on('click', function () {
    disconnect.removeClass('active');
  });
  disconnect.find('.button.success').on('click', function () {
    disconnectChat();
  }); // Smilies

  core.app.find('.smilies.icon').on('click', function (e) {
    // TODO Emoji
    if (e.stopPropagation) {
      e.stopPropagation();
    }
  });
  core.app.find('.smilies.tooltip span').on('click', function () {
    var smilie = $(this).attr('class').replace('sprite ', ''),
        val = $(textarea).val(),
        text = '';

    switch (smilie) {
      case 'Laugh':
        text = ':D';
        break;

      case 'Smile':
        text = ':)';
        break;

      case 'Sad':
        text = ':(';
        break;

      case 'Money':
        text = '$)';
        break;

      case 'Impish':
        text = ':P';
        break;

      case 'Sweat':
        text = ':\\';
        break;

      case 'Cool':
        text = '8)';
        break;

      case 'Frown':
        text = '>:L';
        break;

      case 'Wink':
        text = ';)';
        break;

      case 'Surprise':
        text = ':O';
        break;

      case 'Woo':
        text = '8-)';
        break;

      case 'Tired':
        text = 'X-(';
        break;

      case 'Shock':
        text = '8-O';
        break;

      case 'Hysterical':
        text = 'xD';
        break;

      case 'Kissed':
        text = ':-*';
        break;

      case 'Dizzy':
        text = ':S';
        break;

      case 'Celebrate':
        text = '+O)';
        break;

      case 'Angry':
        text = '>:O';
        break;

      case 'Adore':
        text = '<3';
        break;

      case 'Sleep':
        text = 'zzZ';
        break;

      case 'Stop':
        text = ':X';
        break;
    }

    core.app.find('.message.textarea').val(val + text);
  }); // Restart Event

  $(core.documents.app).on('click', '.restart a', function () {
    var input = core.app.find('.message.container');
    core.app.removeClass('rating completed').addClass('idle');
    core.opts.chatstate = {
      idle: true
    };
    input.find('textarea').removeAttr('disabled');
  }); // Rating Event

  $(core.documents.app).on('click', '.rating.option', function () {
    var selector = $(this),
        score = $(this).attr('data-rating'),
        data = {
      RATING: score
    };
    selector.parent().find('.rating.option[data-rating!="' + score + '"]').removeClass('selected').addClass('deselected');
    selector.removeClass('deselected').addClass('selected');

    if (core.cookies.session && core.cookies.session.length) {
      data = (0, _assign.default)(data, {
        SESSION: core.cookies.session
      });
    }

    $.ajax({
      url: core.opts.server + core.apiPath + core.apiEndpoint.rating,
      data: $.param(data),
      dataType: 'jsonp',
      cache: false,
      xhrFields: {
        withCredentials: true
      }
    });
  });
});

var _default = function _default() {
  var messageTimeout = 1500; // Events

  initEvents();

  if (core.storage.data.chatEnded) {
    return;
  }

  if (core.opts.chatstate.connected && core.settings.language) {
    var data = {
      TIME: Date.now(),
      LANGUAGE: core.settings.locale,
      MESSAGE: message
    };

    if (currentlyTyping === 1) {
      data.TYPING = currentlyTyping;
    } // Cookies


    if (core.cookies.session && core.cookies.session.length) {
      data = (0, _assign.default)(data, {
        SESSION: core.cookies.session
      });

      if (core.messagesInitalised === false) {
        $(core.documents.js).trigger(core.prefix + '.UpdatingMessages', core.settings); // Popup

        if (core.opts.popup) {
          data = (0, _assign.default)(data, {
            OVERRIDE: true
          });
        }
      }

      if (core.opts.operator.id > 0) {
        data = (0, _assign.default)(data, {
          OPERATOR: core.opts.operator.id
        });
      }
    }

    fetch(core.opts.server + core.apiPath + core.apiEndpoint.messages, {
      method: 'POST',
      body: JSON.stringify(data),
      cache: 'no-cache',
      credentials: 'omit',
      headers: {
        'Content-Type': 'application/json'
      }
    }).then(function (response) {
      return response.json();
    }).then(function (data) {
      core.messagesInitalised = true;

      if (data !== null && data !== '') {
        if (data.messages && data.messages.length && core.app.find('.messages').length) {
          outputMessages(data.messages);
        }

        updateTypingStatus(data);
      } else {
        updateTypingStatus(false);
      }

      if (!core.websockets) {
        window.setTimeout(function () {
          return Promise.resolve(/* import() */).then(__webpack_require__.t.bind(null, 132, 7)).then(function (messages) {
            return messages.default();
          });
        }, messageTimeout);
      }
    }).catch(function (e) {
      if (!core.websockets) {
        window.setTimeout(function () {
          return Promise.resolve(/* import() */).then(__webpack_require__.t.bind(null, 132, 7)).then(function (messages) {
            return messages.default();
          });
        }, messageTimeout);
      }

      console.log(e);
    });

    if (promptEmail) {
      promptEmail();
    }
  } else {
    if (!core.messagesInitalised && !core.websockets) {
      window.setTimeout(function () {
        return Promise.resolve(/* import() */).then(__webpack_require__.t.bind(null, 132, 7)).then(function (messages) {
          return messages.default();
        });
      }, messageTimeout);
    }
  }
};

exports.default = _default;

function sendMessage(message) {
  return new Promise(function (resolve) {
    var data = {
      MESSAGE: message
    },
        url = core.opts.server + core.apiPath + core.apiEndpoint.send,
        obj = core.app.find('.message.textarea');

    if (core.cookies.session && core.cookies.session.length) {
      data = (0, _assign.default)(data, {
        SESSION: core.cookies.session
      });

      if (message === 0) {
        $.ajax({
          url: url,
          data: $.param(data),
          dataType: 'jsonp',
          cache: false,
          xhrFields: {
            withCredentials: true
          }
        });
      } else {
        data.JSON = '';
        $.ajax({
          url: url,
          data: $.param(data),
          dataType: 'jsonp',
          cache: false,
          xhrFields: {
            withCredentials: true
          }
        }).done(function (data) {
          if (data && data.length) {
            if (data.id && !core.app.find('.flex[data-id=' + data.id + ']').length) {
              var css = 'message',
                  margin = 15;

              if (core.opts.messageBubbles) {
                css += ' bubble right';
                margin = 0;
              }

              if (!data.datetime) {
                data.datetime = Date.now() / 1000 | 0;
              }

              var html = '<div class="flex right" data-id="' + data.id + '" data-datetime="' + data.datetime + '"><div class="' + css + '" align="left">',
                  username = core.settings.user.length ? core.settings.user : 'Guest';

              if (!core.opts.messageBubbles) {
                html += removeHTML(username) + ' ' + core.settings.language.says + ':<br/>';
              }

              var content = removeHTML(message);

              if (content.length) {
                consecutive = false;
                content = __webpack_require__(132).replaceMessageContent(content);
                html += '<div style="margin: 0 0 0 ' + margin + 'px">' + content + '</div></div></div>';
                core.app.find('.messages').append(html);
                autoCollapseOperatorDetails();
                core.scrollBottom();
              }

              resolve();
            }
          }
        });
        updateTyping(false);
      }

      obj.val('');
      core.storage.store.set('message', '');
    }
  });
}

function escapeHtml(text) {
  var map = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    '\'': '&#039;'
  };
  return text.replace(/[&<>"']/g, function (m) {
    return map[m];
  });
}

function removeHTML(text) {
  text = escapeHtml(text);
  return text;
}

var clickImage = function clickImage(id) {
  return function () {
    core.app.find('.flex[data-id=' + id + '] .fancybox').click();
  };
};

function updateTyping(status) {
  if (status === true) {
    status = 1;
  } else {
    status = 0;
  }

  if (status !== currentlyTyping) {
    currentlyTyping = status;
    $(core.documents.js).trigger(core.prefix + '.UpdateTyping', {
      typing: currentlyTyping
    });
  }
}

function updateOperatorDetails(operator, connected) {
  // Update Typing
  var core = __webpack_require__(64);

  core.app.find('.typing span').text(operator.name + ' ' + core.settings.language.istyping); // Operator Details

  if (!core.app.find('.operator.container').is(':visible')) {
    if (!core.storage.data.operatorDetailsOpen) {
      core.storage.data.operatorDetailsOpen = true;
      core.updateStorage();
    }

    if (operator.department && operator.department.length) {
      var departments = operator.department.split(';');
      $.each(departments, function (key, value) {
        if (value.trim() === core.opts.department.trim()) {
          operator.department = value.trim();
          return;
        }
      });
    }

    var hash = operator.hash ? operator.hash : operator.avatar;
    var department = operator.department ? operator.department : core.storage.data.department;

    if (core.opts.chatBubbles) {
      // Operator Image
      core.operatorImage(operator.id, operator.name, operator.department, '.operator.container .image, .initiate.chat .avatar', hash, true);
      core.app.find('.details.collapse.button').hide();

      if (core.opts.colors && core.opts.colors.image && core.opts.colors.image.border) {
        core.app.css('border', core.opts.colors.image.border);
      }
    } else {
      if (core.opts.operator) {
        operator.id = core.opts.operator.id;
        operator.name = core.opts.operator.firstname;
        operator.hash = hash;
      } // Operator Image


      core.operatorImage(operator.id, operator.name, operator.department, '.operator.container .image, .initiate.chat .avatar', hash, true);
      var container = core.app.find('.operator.container');
      container.find('.name').text(operator.name);
      var messages = core.app.find('.messages');
      var initiate = messages.find('.initiate.chat');
      var element = false;

      if (initiate.length) {
        element = initiate;
      } else {
        element = messages.find('.flex.left').first();
      }

      if (element) {
        element.find('.name').text(operator.name).show();
      }

      element.find('.department').text(department);
      core.container.show();
    }

    if (core.app.is('.no-op')) {
      core.app.find('.details.collapse.button').removeClass('Expand').addClass('Collapse').attr('title', settings.language.collapse);
      core.app.removeClass('no-op');
    }
  }
} // Connecting


function showConnecting() {
  // Add and Show Connecting
  var core = __webpack_require__(64),
      connecting = core.app.find('.connecting');

  if (!connecting.is(':visible')) {
    var messages = core.app.find('.messages .message[data-id!=-1]').length,
        initiate = core.app.attr('data-initiate') === 'true';

    if (!initiate && !messages) {
      // Connecting
      core.opts.chatstate = {
        waiting: true
      };

      if (core.opts.chatstate.waiting && !core.app.is('.connected')) {
        core.app.add(core.container).addClass('connecting');
      }
    }
  }
}

function showChat() {
  var core = __webpack_require__(64);

  if (!core.storage.data.chatEnded) {
    // Connecting
    if (core.opts.chatstate.waiting) {
      showConnecting(); // Load Sprites

      if (core.opts.sprite) {
        $('<img />').on('load', function () {
          // Add CSS
          var head = core.app.closest('html').find('head');
          $('<link href="' + core.opts.server + core.directoryPath + 'templates/' + core.opts.template + '/styles/sprite.min.css" rel="stylesheet" type="text/css"/>').appendTo(head); // Show Message Input

          core.showMessageInput();
        }).attr('src', core.opts.server + core.directoryPath + 'images/Sprite.png');
      } else {
        core.showMessageInput();
      }
    } else {
      var opened = core.storage.data.tabOpen,
          newState = opened ? 'opened' : 'closed',
          oldState = opened ? 'closed hidden' : 'opened';

      if (!core.opts.popup && (core.opts.hidden && newState === 'closed' || core.opts.disabled)) {
        newState = 'hidden';
      }

      if (core.opts.disabled) {
        oldState = oldState.replace(' hidden', '');
      }

      if (core.opts.popup && (core.settings.status === 'Online' || core.opts.chatstate.connected)) {
        oldState = 'closed';
        newState = 'opened';
      }

      core.app.add(core.container).add(core.launcher).removeClass(oldState).addClass(newState).attr('data-opened', opened ? true : false);

      if (opened) {
        core.chatbutton.find('.icon').addClass('close active');
      }

      if (core.app.is('.tab')) {
        core.app.show();
      }

      core.storage.data.tabOpen = opened ? true : false;
      core.updateStorage();
    }
  }
}

function startChat(validate) {
  return new Promise(function (resolve) {
    var core = __webpack_require__(64),
        app = core.app,
        name = app.find('.name.input'),
        department = app.find('.department.input'),
        email = app.find('.email.input'),
        question = app.find('.question.input'),
        other = app.find('.other.input'),
        inputs = app.find('.prechat .inputs'),
        connecting = app.find('.connecting');

    if (app.find('.feedback').length) {
      resolve();
      return;
    }

    var overrideValidation = validate !== undefined && validate === false ? true : false; // Signup Placeholder
    // Connecting

    if (core.opts.chatstate.waiting) {
      showConnecting();
    } // Department


    if (core.opts.department.length) {
      department.val(core.opts.department);
    }

    if (department.length && department.val() !== null) {
      core.storage.data.department = department.val();
      core.updateStorage();
    }

    if (core.settings.requireGuestDetails && !overrideValidation) {
      var errors = {
        name: true,
        email: true,
        department: true
      };
      errors.name = core.validateField(name, '.name.error');

      if (core.settings.loginEmail) {
        errors.email = core.validateEmail(email, '.email.error');
      }

      if (core.settings.departments.length) {
        var collapsed = department.data('collapsed');
        errors.department = core.validateField(department, '.department.error');

        if (!collapsed) {
          department.data('collapsed', true);
          department.css({
            width: department.width() - 35
          });
        }
      }

      if (!errors.name || !errors.email || !errors.department) {
        connecting.hide();
        inputs.show();
        resolve();
        return;
      }
    } // Input


    name = name.length ? name.val() : '';
    department = department.length && department.val() !== null ? department.val() : '';
    email = email.length ? email.val() : '';
    other = other.length ? other.val() : '';
    question = question.length ? question.val() : ''; // Name

    if (name.length) {
      core.settings.user = name;
    }

    var data = {
      NAME: name,
      EMAIL: email,
      DEPARTMENT: department,
      QUESTION: question,
      OTHER: other,
      SERVER: document.location.host,
      JSON: ''
    };

    if (core.cookies.session !== null) {
      data = (0, _assign.default)(data, {
        SESSION: core.cookies.session
      });
    }

    $.ajax({
      url: core.opts.server + core.apiPath + core.apiEndpoint.chat,
      data: $.param(data),
      success: function success(data) {
        // Process JSON Errors / Chat ID
        if (!data.error) {
          if (data.session && data.session.length) {
            // Connecting Event
            $(core.documents.js).trigger(core.prefix + '.Connecting', data); // Update Settings

            core.opts.visitorRefresh = 2000;
            core.updateSettingsTimed();
            app.find('.message.textarea').removeAttr('disabled');
            core.storage.data.chatEnded = false;
            core.updateStorage();
            core.settings.email = data.email;

            if (core.settings.user.length) {
              core.settings.user = data.user;
            }

            if (core.cookies.session !== null) {
              core.cookies.session = data.session;

              if (core.opts.cookie.localStorage) {
                core.storage.store.set(core.cookie.name, core.cookies.session);
              } else {
                Chatstack.cookies.set(core.cookie.name, core.cookies.session, {
                  domain: core.opts.domain,
                  expires: core.cookie.expires
                });
              }
            } // Connecting / Javascript API


            if (!core.opts.disabled) {
              core.opts.chatstate = {
                waiting: true
              };
              core.updateChatState('waiting');
            }

            Promise.resolve(/* import() */).then(__webpack_require__.t.bind(null, 132, 7)).then(function (messages) {
              if (core.queued.length && !core.settings.loginDetails) {
                messages.sendMessage(core.queued[0]).then(function () {
                  core.promptPrechatEmail();
                  messages.showChat();
                });
                core.queued = [];
              } else {
                core.promptPrechatEmail();
                messages.showChat();
              }
            });
            resolve();

            if (core.opts.popup) {
              app.find('.prechat .inputs').hide();
              app.find('.chatting'); //.fadeIn();
            }
          } else {
            resolve();
          }

          if (data.status && data.status === 'Offline') {
            core.closeTab();

            if (!core.opts.hideOffline) {
              core.updateStatusText('Offline');
            }
          }

          Promise.resolve(/* import() */).then(__webpack_require__.t.bind(null, 132, 7)).then(function (messages) {
            messages.promptEmail();
          });
        } else {// Reset Idle
          //core.opts.connected = false;
        }
      },
      dataType: 'jsonp',
      cache: false,
      xhrFields: {
        withCredentials: true
      }
    });
  });
}
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(61)))

/***/ }),

/***/ 133:
/***/ (function(module, exports, __webpack_require__) {

// @@match logic
__webpack_require__(48)('match', 1, function (defined, MATCH, $match) {
  // 21.1.3.11 String.prototype.match(regexp)
  return [function match(regexp) {
    'use strict';
    var O = defined(this);
    var fn = regexp == undefined ? undefined : regexp[MATCH];
    return fn !== undefined ? fn.call(regexp, O) : new RegExp(regexp)[MATCH](String(O));
  }, $match];
});


/***/ })

}]);