(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["offline"],{

/***/ 139:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {

var _interopRequireDefault = __webpack_require__(1);

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = validate;
exports.validateSecurity = validateSecurity;
exports.send = send;

__webpack_require__(81);

__webpack_require__(96);

__webpack_require__(12);

var _assign = _interopRequireDefault(__webpack_require__(107));

// Lodash
// Core
var core = __webpack_require__(64);

function offlineComplete() {
  var core = __webpack_require__(64);

  core.$parent('#OfflineMessageForm').hide();
  core.$parent('.' + core.prefix + 'OfflineSent').show();
  core.$parent(core.selector + 'OfflineHeading').html(core.settings.language.thankyoumessagesent); //.fadeIn();

  $(core.documents.js).trigger('LiveHelp.ContactComplete');
}

function validate(form) {
  return new Promise(function (resolve, reject) {
    var core = __webpack_require__(64),
        name = form.find('.name.input'),
        telephone = form.find('.telephone.input');

    if (name.length && !core.validateField(name, '.name.error')) {
      reject();
    } else if (!core.validateEmail(form.find('.email.input'), '.email.error')) {
      reject();
    } else if (!core.validateField(form.find('.message.input'), '.message.error')) {
      reject();
    }

    if (telephone.length && !core.validateField(telephone, '.telephone.error')) {
      reject();
    }

    __webpack_require__(139).validateSecurity(form.find('.securitycode.input'), '.securitycode.error').then(function () {
      resolve();
    });
  });
}

function validateSecurity(obj, id) {
  return new Promise(function (resolve, reject) {
    var core = __webpack_require__(64),
        field = obj instanceof $ ? obj : $(obj),
        errorClass = 'CrossSmall active',
        successClass = 'TickSmall',
        value = field.val(),
        data = {
      SECURITY: core.opts.security,
      CODE: value,
      JSON: '',
      EMBED: ''
    },
        validate = core.opts.security.substring(16, 56);

    if (field.length) {
      if (value.length !== 5) {
        if (value.length > 5) {
          field.val(value.substring(0, 5));
        }

        core.app.find(id).removeClass(successClass).addClass(errorClass); //.fadeIn();

        reject();
      } else {
        if (validate.length === 40) {
          // Validate Security Code
          if (validate === sha1(value.toUpperCase()).toString()) {
            core.app.find(id).removeClass(errorClass).addClass(successClass);
            resolve();
          } else {
            reject();
          }
        } else {
          $.ajax({
            url: core.opts.server + core.apiPath + core.apiEndpoint.security,
            data: $.param(data),
            dataType: 'jsonp',
            cache: false,
            xhrFields: {
              withCredentials: true
            }
          }).done(function (data) {
            var error = false;

            if (data.result) {
              // Process JSON Errors / Result
              if (data.result) {
                core.app.find(id).removeClass(errorClass).addClass(successClass);
                resolve();
              } else {
                error = true;
              }
            } else {
              error = true;
            } // Error Handling


            if (!error) {
              core.app.find(id).removeClass(successClass).addClass(errorClass);
              reject();
            }
          });
        }
      }
    } else {
      resolve();
    }
  });
}

function send() {
  return new Promise(function (resolve, reject) {
    var core = __webpack_require__(64),
        parent = core.initiatechat.length ? core.initiatechat : core.$parent,
        form = parent.find('.offline .form'),
        name = form.find('.name.input'),
        email = form.find('.email.input'),
        message = form.find('.message.input'),
        security = form.find('.code').attr('data-captcha'),
        captcha = form.find('.security.input'); // Input


    name = name.length ? name.val() : '';
    email = email.length ? email.val() : '';
    message = message.length ? message.val() : ''; // Security Code

    var code = false;

    if (captcha.length) {
      code = '';
      $.each(captcha, function (key, value) {
        code += $(value).val();
      });
    }

    var data = {
      NAME: name,
      EMAIL: email,
      MESSAGE: message,
      JSON: ''
    };

    if (core.settings.captcha && core.settings.captcha.code && security.length) {
      (0, _assign.default)(data, {
        CAPTCHA: code,
        SECURITY: security
      });
    }

    if (core.cookies.session && core.cookies.session.length) {
      (0, _assign.default)(data, {
        SESSION: core.cookies.session
      });
    }

    if (core.opts.template && core.opts.template.length) {
      (0, _assign.default)(data, {
        TEMPLATE: core.opts.template
      });
    }

    parent.addClass('sending');
    $.ajax({
      url: core.opts.server + core.apiPath + core.apiEndpoint.offline,
      data: $.param(data),
      dataType: 'jsonp',
      cache: false,
      xhrFields: {
        withCredentials: true
      }
    }).done(function (data) {
      // Sending
      parent.removeClass('sending'); // Enable Offline Button

      var button = $('#' + core.prefix + 'OfflineButton');

      if (button.length) {
        button.removeAttr('disabled');
      } // Process JSON Errors / Result


      if (data.result && data.result === true) {
        offlineComplete();
        resolve();
      } else {
        var initiate = core.initiatechat;

        if (data.type) {
          if (data.type === 'EMAIL') {
            initiate.find('.email.error').removeClass('TickSmall').addClass('CrossSmall active');
          }

          if (data.type === 'CAPTCHA') {
            initiate.find('.securitycode.error').removeClass('TickSmall').addClass('CrossSmall active');
          }
        }

        var error = initiate.find('.text.error');

        if (data.error && data.error.length) {
          error.html('Error - ' + data.error).parent(); //.fadeIn();
        } else {
          error.text(core.settings.language.offlineerrortitle);
        }

        reject();
      }
    });
  });
}
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(61)))

/***/ })

}]);