/*global Chatstack*/
(function(d, w, prefix, undefined) { // eslint-disable-line no-unused-vars

    function iframe(id, parent, scrolling) {
        var i = d.createElement('iframe');
        i.id = id;
        i.name = id;
        i.className = id;
        i.scrolling = (scrolling) ? 'yes' : 'no';
        i.setAttribute('allowFullScreen', '');
        i.setAttribute('style', 'border: none !important; pointer-events: all');
        parent.appendChild(i);

        var doc = i.contentWindow.document;
        doc.open('text/html', 'replace');
        doc.write('<!doctype html><head></head><body></body></html>');
        doc.close();

        return i;
    }

    function init(d, prefix) {
        // Container
        var id = prefix + '-container';
        var c = d.createElement('div');
        c.id = id;
        c.className = id;
        c.setAttribute('style', 'display: none !important');
        d.body.appendChild(c);

        // JavaScript
        var i = iframe(prefix + '-js-frame', c);

        // Launcher
        iframe(prefix + '-launcher-frame', c);

        var ap = d.createElement('div');
        ap.id = prefix + '-app';
        ap.className = prefix + '-app parent';
        ap.setAttribute('style', 'z-index: 2147483647 !important');
        c.appendChild(ap);

        // App
        iframe(prefix + '-app-frame', ap);

        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.charset = 'utf-8';
        s.async = true;
        s.defer = true;
        s.src = ('https:' == d.location.protocol ? 'https://' : 'http://') + Chatstack.server + '/livehelp/scripts/app.js';

        var cw = i.contentWindow;
        cw.Chatstack = Chatstack;
        cw.document.head.appendChild(s);
    }

    // Document Ready
    var done = false;

    function ready() {
        if (!done) {
            done = true;
            if (Chatstack.delay && Chatstack.delay > 0) {
                setTimeout(function () {
                    init(d, prefix);
                }, Chatstack.delay);
            } else {
                init(d, prefix);
            }
        }
    }

    if (d.readyState === 'complete') {
        ready();
    } else {
        // Mozilla, Opera and WebKit
        if (d.addEventListener) {
            if (Chatstack.delay && (Chatstack.delay === 'load' || Chatstack.delay > 0)) {
                w.addEventListener('load', ready, false);
            } else {
                d.addEventListener('DOMContentLoaded', ready, false);
                w.addEventListener('load', ready, false);
            }
        } else {
            // IE Event Model
            d.attachEvent('onreadystatechange', function () {
                if (d.readyState === 'complete') {
                    ready();
                }
            });
            w.attachEvent('onload', ready);
        }
    }

})(document, window, 'chatstack');